/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.ExcelFormulaAdapter;
import org.qubership.atp.dataset.migration.formula.model.FormulaType;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;

public class ExternalReferenceParser
implements ExcelFormulaAdapter {
    private static final Pattern externalReferenceIF = Pattern.compile("IF\\(\\[1][^!]+!\\$?\\w+\\d+=\"\",\"\",\\[1][^!]+!\\$?\\w+\\d+\\)");
    private static final Pattern externalReferenceT = Pattern.compile("T\\(\\[1][^!]+!\\$\\w+\\d+\\)");

    @Override
    public FormulaType getType() {
        return FormulaType.EXTERNAL_REFERENCE;
    }

    @Override
    public String transform(CellData cellData) throws TransformationException {
        if (!this.matches(cellData)) {
            throw new TransformationException("Text '" + cellData + "' is not external reference");
        }
        String text = cellData.getFormula();
        Matcher matcher = externalReferenceIF.matcher(text);
        if (!matcher.matches()) {
            matcher = externalReferenceT.matcher(text);
        }
        return "${" + matcher.group() + "}";
    }

    @Override
    public boolean matches(CellData cellData) {
        String text = cellData.getFormula();
        return externalReferenceIF.matcher(text).matches() || externalReferenceT.matcher(text).matches();
    }
}

