/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.FormulaType;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;
import org.qubership.atp.dataset.migration.formula.parsers.RegexpFormulaAdapter;

public class RandomExcelParser
extends RegexpFormulaAdapter {
    private static final String RANDOM_REGEXP = "RANDBETWEEN\\(([+-]?\\d+),\\s*([+-]?\\d+)\\)";
    private static final Pattern random = Pattern.compile("RANDBETWEEN\\(([+-]?\\d+),\\s*([+-]?\\d+)\\)");

    @Override
    public FormulaType getType() {
        return FormulaType.RANDOM;
    }

    @Override
    public String transform(CellData cellData) throws TransformationException {
        Matcher matcher = this.getMatcher(cellData);
        return String.format("#RANDOMBETWEEN(%s, %s)", matcher.group(1), matcher.group(2));
    }

    @Override
    protected Pattern getPattern() {
        return random;
    }

    @Override
    protected String getFormulaDescription() {
        return RANDOM_REGEXP;
    }
}

