/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.apply;

import com.google.common.base.Preconditions;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.migration.formula.model.AttachedFiles;
import org.qubership.atp.dataset.migration.formula.model.Formula;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;
import org.qubership.atp.dataset.migration.model.ToCreate;
import org.qubership.atp.dataset.migration.repo.DsServicesFacade;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.file.FileData;

public interface CreateParam {
    public static final CreateParam TEXT = (using, target, value) -> {
        Attribute attr = using.get_Attr_ByNameOrCreate(target.getDsl(), target.getAttrName(), AttributeType.TEXT, null, null);
        return using.get_Param_ByNameOrCreate(target.getDs(), attr, null);
    };
    public static final CreateParam LIST_VALUE = new CreateParam(){

        @Override
        @Nonnull
        public Parameter createParameter(DsServicesFacade using, ToCreate target, Formula value) {
            Attribute attr = using.get_Attr_ByNameOrCreate(target.getDsl(), target.getAttrName(), AttributeType.LIST, null, Collections.singletonList(value.getDatasetValue()));
            Preconditions.checkArgument((AttributeType.LIST == attr.getType() ? 1 : 0) != 0, (String)"Existing attribute has type '%s', but type '%s' expected.", (Object)attr.getType(), (Object)AttributeType.LIST);
            return using.get_Param_ByNameOrCreate(target.getDs(), attr, null);
        }
    };
    public static final CreateParam FILE = (using, target, value) -> {
        Attribute attr = using.get_Attr_ByNameOrCreate(target.getDsl(), target.getAttrName(), AttributeType.FILE, null, null);
        Parameter parameter = using.get_Param_ByNameOrCreate(target.getDs(), attr, null);
        FileData fileData = AttachedFiles.createFileParameterFromAttachedFile(value.getFile(), parameter.getId());
        parameter.setFileData(fileData);
        return parameter;
    };

    @Nonnull
    public Parameter createParameter(DsServicesFacade var1, ToCreate var2, Formula var3) throws TransformationException;
}

