/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula;

import java.util.HashSet;
import java.util.Set;
import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.ExcelFormulaAdapter;
import org.qubership.atp.dataset.migration.formula.model.Formula;
import org.qubership.atp.dataset.migration.formula.model.FormulaType;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;
import org.qubership.atp.dataset.migration.formula.parsers.ConcatenateIntReferenceParser;
import org.qubership.atp.dataset.migration.formula.parsers.DateParser;
import org.qubership.atp.dataset.migration.formula.parsers.ExternalReferenceParser;
import org.qubership.atp.dataset.migration.formula.parsers.InternalReferenceParser;
import org.qubership.atp.dataset.migration.formula.parsers.ListValueFormulaParser;
import org.qubership.atp.dataset.migration.formula.parsers.LowcaseUuidParser;
import org.qubership.atp.dataset.migration.formula.parsers.RandomCharParser;
import org.qubership.atp.dataset.migration.formula.parsers.RandomExcelParser;
import org.qubership.atp.dataset.migration.formula.parsers.SimpleTextExcelParser;
import org.qubership.atp.dataset.migration.formula.parsers.UuidParser;
import org.qubership.atp.dataset.migration.model.FalloutReport;

public class ExcelFormulasEvaluator {
    private final FalloutReport report;
    private Set<ExcelFormulaAdapter> adapters = new HashSet<ExcelFormulaAdapter>();

    public ExcelFormulasEvaluator(FalloutReport report) {
        this(true, report);
    }

    public ExcelFormulasEvaluator(boolean fillWithDefaultParsers, FalloutReport report) {
        this.report = report;
        if (fillWithDefaultParsers) {
            this.add(new ConcatenateIntReferenceParser(this));
            this.add(new RandomExcelParser());
            this.add(new SimpleTextExcelParser());
            this.add(new ExternalReferenceParser());
            this.add(new LowcaseUuidParser());
            this.add(new UuidParser());
            this.add(new InternalReferenceParser());
            this.add(new DateParser());
            this.add(new RandomCharParser());
            this.add(new ListValueFormulaParser());
        }
    }

    public void add(ExcelFormulaAdapter parsers) {
        this.adapters.add(parsers);
    }

    public Formula getFormula(CellData cellData) {
        String excelFormula = cellData.getFormula();
        for (ExcelFormulaAdapter adapter : this.adapters) {
            if (!adapter.matches(cellData)) continue;
            try {
                String datasetValue = adapter.transform(cellData);
                return new Formula(cellData, adapter.getType(), datasetValue, null);
            }
            catch (TransformationException e) {
                this.report.report(cellData.getLocation(), excelFormula, String.format("failed to convert formula to '%s'", new Object[]{adapter.getType()}), e.getMessage());
            }
        }
        this.report.report(cellData.getLocation(), excelFormula, "unknown formula", "");
        return new Formula(cellData, FormulaType.UNKNOWN, "UNKNOWN: " + excelFormula, null);
    }
}

