/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.model;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.qubership.atp.dataset.migration.Progress;
import org.qubership.atp.dataset.migration.formula.model.AttachedFiles;
import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.Formula;
import org.qubership.atp.dataset.migration.formula.model.ParameterAssociation;
import org.qubership.atp.dataset.migration.model.ExcelEvaluator;
import org.qubership.atp.dataset.migration.model.FalloutReport;
import org.qubership.atp.dataset.migration.model.ParameterData;
import org.qubership.atp.dataset.migration.model.ToCreate;
import org.qubership.atp.dataset.migration.model.ToOverlap;
import org.qubership.atp.dataset.migration.repo.DsServicesFacade;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.ParameterOverlap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationContext {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluationContext.class);
    private static final EvaluationContext thiz = new EvaluationContext();
    private final Map<String, ParameterAssociation> calculatedHash = new HashMap<String, ParameterAssociation>();

    private EvaluationContext() {
    }

    public static EvaluationContext getContext() {
        return thiz;
    }

    public static String getCellAddress(Cell cell) {
        return cell.getAddress().formatAsString();
    }

    public ParameterAssociation put(ExcelEvaluator excelEvaluator, Cell cell, ParameterData parameterSup) {
        ParameterAssociation parameterAssoc = new ParameterAssociation(new CellData(excelEvaluator, cell), parameterSup);
        this.put(EvaluationContext.getCellAddress(cell), parameterAssoc);
        return parameterAssoc;
    }

    public void put(String address, ParameterAssociation parameter) {
        this.calculatedHash.put(address, parameter);
    }

    public ParameterAssociation get(CellData cellData) {
        return this.calculatedHash.get(cellData.getFormula());
    }

    public void clear() {
        this.calculatedHash.clear();
    }

    public void evaluateAndFlushAll(ExcelEvaluator evaluateWith, DsServicesFacade flushWith, FalloutReport report, XSSFWorkbook book) {
        LOG.info("Flushing " + this.calculatedHash.size() + " items");
        List<Ole10Native> files = AttachedFiles.createAttachedFiles(book, report);
        Progress progress = Progress.withTimeThreshold(percents -> LOG.info("Progress: {}%", percents), this.calculatedHash.size());
        LinkedHashMap paramsToSetValueTo = new LinkedHashMap();
        this.getParametersToBeCalculated().forEach(param -> {
            Formula formula = evaluateWith.getFormulaValue((ParameterAssociation)param, files);
            if (param.parameterSup.isOverlap()) {
                this.overlapParameter(flushWith, report, param.parameterSup.toOverlap(), formula);
                progress.increment(1.0);
            } else {
                ToCreate target = param.parameterSup.toCreate();
                Optional<Parameter> created = this.createParameter(flushWith, report, target, formula);
                if (created.isPresent()) {
                    paramsToSetValueTo.put(target, new AbstractMap.SimpleEntry<Parameter, Formula>(created.get(), formula));
                    progress.increment(0.5);
                } else {
                    progress.increment(1.0);
                }
            }
        });
        for (Map.Entry entry : paramsToSetValueTo.entrySet()) {
            ToCreate source = (ToCreate)entry.getKey();
            Parameter target = (Parameter)((Map.Entry)entry.getValue()).getKey();
            Formula value = (Formula)((Map.Entry)entry.getValue()).getValue();
            this.setParameterValue(flushWith, report, source, target, value);
            progress.increment(0.5);
        }
        LOG.info("Flushing done");
    }

    private Optional<ParameterOverlap> overlapParameter(DsServicesFacade flushWith, FalloutReport report, ToOverlap target, Formula value) {
        try {
            ParameterOverlap result = value.getFormulaType().overlap.overlapParameter(flushWith, target, value);
            return Optional.ofNullable(result);
        }
        catch (Exception e) {
            report.report(value.getLocation(), target.getLocation() + "=" + value.getDatasetValue(), e.getMessage(), "parameter " + target + " can not be overlapped with value " + value);
            return Optional.empty();
        }
    }

    private Optional<Parameter> createParameter(DsServicesFacade flushWith, FalloutReport report, ToCreate source, Formula value) {
        try {
            Parameter parameter = value.getFormulaType().createParam.createParameter(flushWith, source, value);
            return Optional.of(parameter);
        }
        catch (Exception e) {
            report.report(value.getLocation(), source.getLocation() + "=" + value.getDatasetValue(), e.getMessage(), "parameter " + value + " can not be created");
            return Optional.empty();
        }
    }

    private boolean setParameterValue(DsServicesFacade flushWith, FalloutReport report, ToCreate source, Parameter target, Formula value) {
        try {
            value.getFormulaType().setParam.setParameterValue(flushWith, source, target, value);
            return true;
        }
        catch (Exception e) {
            report.report(value.getLocation(), source.getLocation() + "=" + value.getDatasetValue(), e.getMessage(), "parameter value " + value + " can not be set to parameter " + source);
            return false;
        }
    }

    public Stream<ParameterAssociation> getParametersToBeCalculated() {
        return this.calculatedHash.entrySet().stream().map(Map.Entry::getValue);
    }
}

