/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.model;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.qubership.atp.dataset.migration.formula.ExcelFormulasEvaluator;
import org.qubership.atp.dataset.migration.model.ExcelEvaluator;
import org.qubership.atp.dataset.migration.model.FalloutReport;
import org.qubership.atp.dataset.migration.repo.DsServicesFacade;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportResources
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ImportResources.class);
    public final DsServicesFacade services;
    public final ExcelEvaluator excelEvaluator;
    public final FalloutReport falloutReport;
    public final String bookName;
    public final String groupDataSetName;
    public final XSSFWorkbook book;
    public final VisibilityArea va;

    public ImportResources(DsServicesFacade services, ExcelEvaluator excelEvaluator, FalloutReport falloutReport, String bookName, String groupDataSetName, XSSFWorkbook book, VisibilityArea va) {
        this.services = services;
        this.excelEvaluator = excelEvaluator;
        this.falloutReport = falloutReport;
        this.bookName = bookName;
        this.groupDataSetName = groupDataSetName;
        this.book = book;
        this.va = va;
    }

    public static ImportResources create(DsServicesFacade services, String visibilityAreaName, String excelDataFolder, String bookName, String groupDataSetName) throws IOException, InvalidFormatException {
        FalloutReport falloutReport = new FalloutReport(bookName + ".fallout.tsv");
        ExcelEvaluator excelEvaluator = new ExcelEvaluator(Files.find(Paths.get(excelDataFolder, new String[0]), Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && !path.startsWith("~$") && path.getFileName().toString().toLowerCase().matches(".+\\.xlsx"), new FileVisitOption[0]).collect(Collectors.toList()), new ExcelFormulasEvaluator(falloutReport));
        XSSFWorkbook book = excelEvaluator.register(Paths.get(bookName, new String[0]));
        VisibilityArea va = services.get_VA_ByNameOrCreate(visibilityAreaName);
        return new ImportResources(services, excelEvaluator, falloutReport, bookName, groupDataSetName, book, va);
    }

    @Override
    public void close() {
        try {
            this.book.close();
        }
        catch (IOException e) {
            LOG.error("FAILED TO CLOSE EXCEL BOOK : " + this.bookName);
            LOG.error(Throwables.getStackTraceAsString((Throwable)e));
        }
        this.excelEvaluator.release();
        try {
            this.falloutReport.close();
        }
        catch (Exception e) {
            LOG.error("FAILED TO CLOSE FALLOUT REPORT : " + this.falloutReport.toString());
            LOG.error(Throwables.getStackTraceAsString((Throwable)e));
        }
    }
}

