/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration;

import java.io.IOException;
import java.util.Properties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.qubership.atp.dataset.migration.ChildDsImporter;
import org.qubership.atp.dataset.migration.ParentDsImporter;
import org.qubership.atp.dataset.migration.config.MigrationConfig;
import org.qubership.atp.dataset.migration.model.ImportResources;
import org.qubership.atp.dataset.migration.model.Settings;
import org.qubership.atp.dataset.migration.repo.DsServicesFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.context.annotation.Import;

@SpringBootConfiguration
@Import(value={MigrationConfig.class})
public class DataSetImporter
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetImporter.class);
    private Settings settings;
    private DsServicesFacade dsServicesFacade;

    @Autowired
    public DataSetImporter(Properties properties, DsServicesFacade dsServicesFacade) {
        this.settings = Settings.getSettings(properties);
        this.dsServicesFacade = dsServicesFacade;
    }

    public DataSetImporter(Settings settings, DsServicesFacade dsServicesFacade) {
        this.settings = settings;
        this.dsServicesFacade = dsServicesFacade;
    }

    public static void main(String[] args) throws Exception {
        LOGGER.info("Importer version: " + DataSetImporter.class.getPackage().getImplementationVersion());
        try {
            SpringApplication.run(DataSetImporter.class, (String[])args);
        }
        catch (Exception e) {
            LOGGER.error("Failed to import excel files: " + e.getMessage(), (Throwable)e);
        }
    }

    public void run(String ... args) throws IOException, InvalidFormatException {
        String vaName = this.settings.getVisibilityArea();
        String dslName = this.settings.getDslName();
        String excelFolder = this.settings.getExcelFolder();
        String parentFileName = this.settings.getParentExcelDatasetLocation();
        String groupDataSetName = this.settings.getDefaultGroupDataSetName();
        Boolean rootAttrFlag = this.settings.getRootAttrFlag();
        if (parentFileName != null && !parentFileName.isEmpty()) {
            ParentDsImporter.process(ImportResources.create(this.dsServicesFacade, vaName, excelFolder, parentFileName, groupDataSetName), rootAttrFlag);
        } else {
            LOGGER.warn("PARENT FILE PROCESSING SKIPPED, because parent file is not specified");
        }
        String childFileName = this.settings.getChildExcelDatasetLocation();
        if (childFileName != null && !childFileName.isEmpty()) {
            ChildDsImporter.process(ImportResources.create(this.dsServicesFacade, vaName, excelFolder, this.settings.getChildExcelDatasetLocation(), groupDataSetName), dslName, rootAttrFlag);
        } else {
            LOGGER.warn("CHILD FILE PROCESSING SKIPPED, because child file is not specified");
        }
    }
}

