/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.qubership.atp.dataset.migration.DsRow;
import org.qubership.atp.dataset.migration.SheetDataIterator;
import org.qubership.atp.dataset.migration.formula.model.EvaluationContext;
import org.qubership.atp.dataset.migration.model.ImportResources;
import org.qubership.atp.dataset.migration.model.ParamContainer;
import org.qubership.atp.dataset.migration.model.ToCreate;
import org.qubership.atp.dataset.migration.repo.DsServicesFacade;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentDsImporter {
    private static final Logger LOG = LoggerFactory.getLogger(ParentDsImporter.class);
    private ImportResources res;

    public ParentDsImporter(ImportResources res) {
        this.res = res;
    }

    public static ParentDsImporter create(ImportResources resources) {
        return new ParentDsImporter(resources);
    }

    public static void process(ImportResources resources, Boolean rootAttr) {
        ParentDsImporter.create(resources).process(rootAttr);
    }

    public void process(Boolean rootAttr) {
        if (this.res.book.getNumberOfSheets() > 1) {
            this.res.falloutReport.report(this.res.bookName, "-", "parent book should has only ONE sheet", "");
        }
        XSSFSheet sheet = this.res.book.getSheetAt(0);
        LOG.info("Processing sheet: " + sheet.getSheetName());
        try {
            this.processParentDataSet((Iterator<DsRow>)((Object)SheetDataIterator.create((Sheet)sheet, 2, this.res.excelEvaluator)), rootAttr);
        }
        catch (Exception e) {
            LOG.error("FAILED TO PROCESS SHEET : " + sheet.getSheetName() + " from file: " + e);
            LOG.error(Throwables.getStackTraceAsString((Throwable)e));
            this.res.falloutReport.report(sheet.getSheetName(), "-", "failed to process sheet", e.getMessage());
        }
        this.res.close();
    }

    private void processParentDataSet(Iterator<DsRow> sheetData, Boolean rootAttr) {
        Group group = null;
        EvaluationContext.getContext().clear();
        if (rootAttr.booleanValue()) {
            sheetData = Iterators.filter(sheetData, dsRow -> !"default".equals(dsRow.getGroup()));
        }
        while (sheetData.hasNext()) {
            DsRow row = (DsRow)sheetData.next();
            if (row.gotNewGroup()) {
                group = Group.create(this.res.services, this.res.va, row.getGroup(), this.res.groupDataSetName);
            }
            if (row.getParameterKey() == null) continue;
            ParentParameterSup parameterSup = new ParentParameterSup(group, row.getParameterKey());
            Cell cell = row.getParameterValueCell();
            EvaluationContext.getContext().put(this.res.excelEvaluator, cell, parameterSup);
        }
        EvaluationContext.getContext().evaluateAndFlushAll(this.res.excelEvaluator, this.res.services, this.res.falloutReport, this.res.book);
    }

    static class Group
    implements ParamContainer {
        private final DataSet groupDs;

        private Group(DataSet groupDs) {
            this.groupDs = groupDs;
        }

        static Group create(DsServicesFacade services, VisibilityArea va, String groupDslName, String groupDsName) {
            DataSetList groupDsl = services.getDslByNameOrCreate(va, groupDslName);
            DataSet groupDs = services.get_DS_ByNameOrCreate(groupDsName, groupDsl);
            return new Group(groupDs);
        }

        @Override
        public DataSet getGroupDs() {
            return this.groupDs;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("groupDs", (Object)this.groupDs).toString();
        }
    }

    static class ParentParameterSup
    extends ToCreate {
        private final Group parent;
        private final String key;

        private ParentParameterSup(Group parent, String key) {
            this.parent = parent;
            this.key = key;
        }

        @Override
        @Nonnull
        public ParamContainer getContainer() {
            return this.parent;
        }

        @Override
        @Nonnull
        public String getAttrName() {
            return this.key;
        }
    }
}

