/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.FormulaType;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;
import org.qubership.atp.dataset.migration.formula.parsers.RegexpFormulaAdapter;

public class DateParser
extends RegexpFormulaAdapter {
    private static final String DATE_REGEX = "CONCATENATE\\(TEXT\\(([^,]+),\"yyyy-MM-dd\"\\),CONCATENATE\\(\"T\",CONCATENATE\\(TEXT\\(([^\"]+),\"HH:mm:ss\"\\),\"([^\"]+)\"\\)\\)\\)";
    private static final Pattern DATE_PATTERN = Pattern.compile("CONCATENATE\\(TEXT\\(([^,]+),\"yyyy-MM-dd\"\\),CONCATENATE\\(\"T\",CONCATENATE\\(TEXT\\(([^\"]+),\"HH:mm:ss\"\\),\"([^\"]+)\"\\)\\)\\)");
    private static final Pattern DATE_DELAY = Pattern.compile("TODAY\\(\\)\\s*([+-]\\d+)");
    private static final Pattern TIME_EXPRESSION = Pattern.compile("TIME\\((\\d{1,2}),\\s*(\\d{1,2}),\\s*(\\d{1,2})\\)");

    @Override
    protected Pattern getPattern() {
        return DATE_PATTERN;
    }

    @Override
    protected String getFormulaDescription() {
        return "CONCATENATE\\(TEXT\\(([^,]+),\"yyyy-MM-dd\"\\),CONCATENATE\\(\"T\",CONCATENATE\\(TEXT\\(([^\"]+),\"HH:mm:ss\"\\),\"([^\"]+)\"\\)\\)\\) (custom excel date formula)";
    }

    @Override
    public FormulaType getType() {
        return FormulaType.DATE;
    }

    @Override
    public String transform(CellData cellData) throws TransformationException {
        Matcher matcher = this.getMatcher(cellData);
        String date = matcher.group(1);
        String time = matcher.group(2);
        String suffix = matcher.group(3);
        date = this.transformDate(date);
        time = this.transformTime(time);
        suffix = this.transformSuffix(suffix);
        return String.format("#DATE(%s'T'%s%s)", date, time, suffix);
    }

    private String transformSuffix(String suffix) {
        return suffix.replaceAll("([a-zA-Z]+)", "'$1'");
    }

    private String transformDate(String date) {
        Matcher dateDelayMatcher;
        if ("NOW()".equalsIgnoreCase(date) || "TODAY()".equalsIgnoreCase(date)) {
            date = "yyyy-MM-dd";
        }
        if ((dateDelayMatcher = DATE_DELAY.matcher(date)).matches()) {
            date = dateDelayMatcher.group(1) + "d, yyyy-MM-dd";
        }
        return date;
    }

    private String transformTime(String time) {
        Matcher timeFormatMatcher;
        if ("NOW()".equalsIgnoreCase(time) || "TODAY()".equalsIgnoreCase(time)) {
            time = "HH:mm:ss";
        }
        if ((timeFormatMatcher = TIME_EXPRESSION.matcher(time)).matches()) {
            Integer hours = Integer.valueOf(timeFormatMatcher.group(1));
            Integer minutes = Integer.valueOf(timeFormatMatcher.group(2));
            Integer seconds = Integer.valueOf(timeFormatMatcher.group(3));
            time = String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return time;
    }
}

