/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.model;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.model.ExternalLinksTable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.qubership.atp.dataset.migration.formula.ExcelFormulasEvaluator;
import org.qubership.atp.dataset.migration.formula.model.AttachedFiles;
import org.qubership.atp.dataset.migration.formula.model.Formula;
import org.qubership.atp.dataset.migration.formula.model.FormulaType;
import org.qubership.atp.dataset.migration.formula.model.ParameterAssociation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelEvaluator {
    private static final Pattern ATP_MACROS_PATTERN = Pattern.compile("\\$(ENV_VARIABLE|RAND)\\(([^)]*)\\)");
    private static final Logger LOG = LoggerFactory.getLogger(ExcelEvaluator.class);
    private final List<Path> refFiles;
    private Map<XSSFWorkbook, FormulaEvaluator> evaluators = new HashMap<XSSFWorkbook, FormulaEvaluator>();
    private Map<Path, XSSFWorkbook> filesToExcel = new HashMap<Path, XSSFWorkbook>();
    private Map<XSSFWorkbook, XSSFWorkbook> childParentMapping = new HashMap<XSSFWorkbook, XSSFWorkbook>();
    private ExcelFormulasEvaluator formulaEvaluator;

    public ExcelEvaluator(List<Path> refFiles, ExcelFormulasEvaluator formulaEvaluator) {
        this.refFiles = refFiles;
        this.formulaEvaluator = formulaEvaluator;
    }

    private static Set<String> getRefs(@Nonnull XSSFWorkbook workbook) {
        List links = workbook.getExternalLinksTable();
        if (links == null || links.isEmpty()) {
            return Sets.newHashSet();
        }
        HashSet paths = Sets.newHashSetWithExpectedSize((int)links.size());
        for (ExternalLinksTable t : links) {
            String fileName = t.getLinkedFileName();
            if (fileName == null) continue;
            String path = PackagingURIHelper.decodeURI((URI)URI.create(fileName));
            Paths.get(path, new String[0]);
            paths.add(path);
        }
        return paths;
    }

    public XSSFWorkbook register(Path file) throws IOException, InvalidFormatException {
        if (this.filesToExcel.get(file) != null) {
            return this.filesToExcel.get(file);
        }
        LOG.info("FILE: " + file);
        XSSFWorkbook book = (XSSFWorkbook)WorkbookFactory.create((File)file.toFile(), null, (boolean)true);
        this.filesToExcel.put(file, book);
        XSSFFormulaEvaluator childBookEvaluator = book.getCreationHelper().createFormulaEvaluator();
        this.evaluators.put(book, (FormulaEvaluator)childBookEvaluator);
        HashMap<String, Object> workbooks = new HashMap<String, Object>();
        workbooks.put(PackagingURIHelper.encode((String)file.getFileName().toString()), childBookEvaluator);
        Set<String> refs = ExcelEvaluator.getRefs(book);
        if (refs.size() > 1) {
            throw new InvalidFormatException("File should have only one references to external excel files: " + file + ". But has " + refs.size() + " : " + refs);
        }
        if (!refs.isEmpty()) {
            String reference = refs.iterator().next();
            Optional<Path> s = this.refFiles.stream().filter(path -> path.getFileName().toString().equals(reference)).findFirst();
            if (s.isPresent()) {
                XSSFWorkbook parent = this.register(s.get());
                this.childParentMapping.put(book, parent);
                workbooks.put(PackagingURIHelper.encode((String)reference), this.evaluators.get(parent));
            }
        }
        childBookEvaluator.setupReferencedWorkbooks(workbooks);
        return book;
    }

    @Nonnull
    public String getValue(Cell cell) {
        try {
            return this.getValueUnSafe(cell);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    public Formula getFormulaValue(ParameterAssociation parameter, List<Ole10Native> files) {
        if (parameter.data.getCellType() == CellType.FORMULA) {
            return this.formulaEvaluator.getFormula(parameter.data);
        }
        Optional<Ole10Native> file = AttachedFiles.findFileFromList(files, parameter.parameterSup.getAttrName(), parameter.parameterSup.getDs().getName());
        if (file.isPresent()) {
            return new Formula(parameter.data, FormulaType.FILE, file.get().getLabel(), file.get());
        }
        FormulaType formulaType = FormulaType.TEXT;
        Matcher matcher = ATP_MACROS_PATTERN.matcher(parameter.data.getValue());
        StringBuffer valueSb = new StringBuffer();
        while (matcher.find()) {
            String convertedValue;
            formulaType = FormulaType.ATP_MACROS;
            String macroName = matcher.group(1);
            if (macroName.equalsIgnoreCase("ENV_VARIABLE")) {
                String macroArgs = matcher.group(2);
                convertedValue = "#CONTEXT(" + macroArgs + ")";
            } else if (macroName.equalsIgnoreCase("RAND")) {
                String macroArg = matcher.group(2).replaceAll("'", "");
                String parameters = this.transformIntToRange(macroArg);
                convertedValue = "#RANDOMBETWEEN(" + parameters + ")";
            } else {
                convertedValue = parameter.data.getValue();
            }
            matcher.appendReplacement(valueSb, convertedValue);
        }
        matcher.appendTail(valueSb);
        return new Formula(parameter.data, formulaType, valueSb.toString(), null);
    }

    private String transformIntToRange(String macroArg) {
        int number = Integer.parseInt(macroArg);
        long firstArg = 1L;
        long secondArg = 9L;
        if (number >= 2) {
            for (int i = 1; i < number; ++i) {
                firstArg *= 10L;
                secondArg *= 10L;
                secondArg += 9L;
            }
            return firstArg + "," + secondArg;
        }
        return "0,9";
    }

    private String getValueUnSafe(Cell cell) throws IllegalArgumentException {
        DataFormatter dataFormatter = new DataFormatter(Locale.ENGLISH);
        String result = "";
        if (cell != null) {
            try {
                FormulaEvaluator evaluator = this.evaluators.get(cell.getSheet().getWorkbook());
                result = dataFormatter.formatCellValue(cell, evaluator);
            }
            catch (Exception e) {
                if (cell.getCellTypeEnum() == CellType.ERROR) {
                    result = cell instanceof XSSFCell ? ((XSSFCell)cell).getErrorCellString() : "####";
                }
                throw new RuntimeException("Cell parsing report\tSheet: " + cell.getSheet().getSheetName() + ", \tRow: " + (cell.getRowIndex() + 1) + ", \tCell: " + (cell.getColumnIndex() + 1) + ", \tValue: " + result, e);
            }
        }
        return result == null ? "" : result.trim();
    }

    public void registerAll() throws IOException, InvalidFormatException {
        for (Path p : this.refFiles) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.register(p);
            LOG.info(p + " = " + stopwatch.stop().elapsed(TimeUnit.SECONDS));
        }
    }

    public void release() {
        this.filesToExcel.forEach((path, workbook) -> {
            try {
                workbook.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.filesToExcel = new HashMap<Path, XSSFWorkbook>();
    }

    public Workbook getParentBook(XSSFWorkbook childBook) {
        return (Workbook)this.childParentMapping.get(childBook);
    }
}

