/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.model;

import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Settings {
    private static final Logger LOG = LoggerFactory.getLogger(Settings.class);
    private String excelFolder;
    private String parentFileName;
    private String childFileName;
    private String dslName;
    private String vaName;
    private String defaultGroupDataSetName;
    private String rootAttr;

    public Settings() {
    }

    public Settings(@Nonnull String excelFolder, @Nullable String parentFileName, @Nullable String childFileName, @Nonnull String vaName, @Nonnull String dslName, @Nonnull String defaultGroupDataSetName, @Nullable String rootAttr) {
        this.excelFolder = excelFolder;
        this.parentFileName = parentFileName;
        this.childFileName = childFileName;
        this.dslName = dslName;
        this.vaName = vaName;
        this.defaultGroupDataSetName = defaultGroupDataSetName;
        this.rootAttr = rootAttr;
    }

    public static Settings getSettings(Properties properties) throws IllegalArgumentException {
        Settings settings = new Settings();
        try {
            settings.excelFolder = Settings.getMandatorySetting(properties, "excel_folder");
            if (!settings.excelFolder.endsWith("/")) {
                settings.excelFolder = settings.excelFolder + "/";
            }
            settings.parentFileName = Settings.getOptionalSetting(properties, "parent_file_name");
            settings.childFileName = Settings.getOptionalSetting(properties, "child_file");
            settings.vaName = Settings.getMandatorySetting(properties, "va_name");
            settings.dslName = Settings.getMandatorySetting(properties, "dsl_name");
            settings.defaultGroupDataSetName = Settings.getMandatorySetting(properties, "default_group_dataset_name");
            settings.rootAttr = Settings.getOptionalSetting(properties, "root_attr");
        }
        catch (IllegalArgumentException e) {
            Settings.printHelp();
            throw new IllegalArgumentException("One of arguments in not specified: " + e.getMessage(), e);
        }
        return settings;
    }

    private static void printHelp() {
        LOG.error("ImporterDT  -Dexcel_folder=folder_with_all_excel_files -Dparent_file_name=PARENT.xlsx  -Dchild_file_name=CHILD.xlsx  -Dva_name=visibility_name_to_store_data  -Ddsl_name=data_set_list_name_to_store_data_sets_from_child_excel -Ddefault_group_dataset_name=group_data_set_default_name_for_groups_parameters");
    }

    private static String getMandatorySetting(Properties properties, String propertyName) {
        String value = Settings.getOptionalSetting(properties, propertyName);
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Mandatory property is not specified: " + propertyName);
        }
        return value;
    }

    private static String getOptionalSetting(Properties properties, String propertyName) {
        return properties.getProperty(propertyName);
    }

    public String getExcelFolder() {
        return this.excelFolder;
    }

    public String getParentExcelDatasetLocation() {
        return this.getExcelDatasetLocation(this.parentFileName);
    }

    public String getChildExcelDatasetLocation() {
        return this.getExcelDatasetLocation(this.childFileName);
    }

    private String getExcelDatasetLocation(String fileName) {
        if (Objects.isNull(fileName)) {
            return null;
        }
        String trimmedFileName = fileName.trim();
        if (trimmedFileName.isEmpty()) {
            return null;
        }
        return this.excelFolder + fileName;
    }

    public String getVisibilityArea() {
        return this.vaName;
    }

    public String getDslName() {
        return this.dslName;
    }

    public String getDefaultGroupDataSetName() {
        return this.defaultGroupDataSetName;
    }

    public Boolean getRootAttrFlag() {
        return Boolean.parseBoolean(this.rootAttr);
    }
}

