/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.qubership.atp.dataset.migration.DsRow;
import org.qubership.atp.dataset.migration.SheetDataIterator;
import org.qubership.atp.dataset.migration.formula.model.EvaluationContext;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;
import org.qubership.atp.dataset.migration.model.ImportResources;
import org.qubership.atp.dataset.migration.model.OverlapParamContainer;
import org.qubership.atp.dataset.migration.model.ParamContainer;
import org.qubership.atp.dataset.migration.model.ToCreate;
import org.qubership.atp.dataset.migration.model.ToOverlap;
import org.qubership.atp.dataset.migration.repo.DsServicesFacade;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildDsImporter {
    private static final Logger LOG = LoggerFactory.getLogger(ChildDsImporter.class);
    private final ImportResources res;
    private final DataSetList dsl;

    public ChildDsImporter(ImportResources res, DataSetList dsl) {
        this.res = res;
        this.dsl = dsl;
    }

    public static ChildDsImporter create(ImportResources resources, String dslName) {
        DataSetList dataSetList = resources.services.getDslByNameOrCreate(resources.va, dslName);
        return new ChildDsImporter(resources, dataSetList);
    }

    public static void process(ImportResources resources, String dslName, Boolean rootAttr) {
        ChildDsImporter.create(resources, dslName).process(rootAttr);
    }

    public void process(Boolean rootAttr) {
        for (Sheet sheet1 : this.res.book) {
            EvaluationContext.getContext().clear();
            XSSFSheet sheet = (XSSFSheet)sheet1;
            try {
                Row headerRow = (Row)sheet.rowIterator().next();
                LOG.info("Processing sheet: " + sheet.getSheetName());
                for (int columnIndex = 2; columnIndex < headerRow.getLastCellNum(); ++columnIndex) {
                    String datasetName = this.res.excelEvaluator.getValue(headerRow.getCell(columnIndex));
                    if (datasetName.isEmpty()) continue;
                    LOG.info("Processing data set: " + datasetName);
                    this.processChildDataSet((Iterator<DsRow>)((Object)SheetDataIterator.create((Sheet)sheet, columnIndex, this.res.excelEvaluator)), datasetName, rootAttr);
                }
                EvaluationContext.getContext().evaluateAndFlushAll(this.res.excelEvaluator, this.res.services, this.res.falloutReport, this.res.book);
            }
            catch (Exception e) {
                LOG.error("FAILED TO PROCESS SHEET : " + sheet.getSheetName() + " from file", (Throwable)e);
                this.res.falloutReport.report(sheet.getSheetName(), "-", "failed to process sheet", e.getMessage());
            }
        }
        this.res.close();
    }

    private void processChildDataSet(Iterator<DsRow> sheetData, String dataSetName, Boolean rootAttr) {
        DataSet childDataSet = this.res.services.get_DS_ByNameOrCreate(dataSetName, this.dsl);
        ChildDsParamContainer paramContainer = ChildDsParamContainer.create(childDataSet);
        Group group = null;
        while (sheetData.hasNext()) {
            DsRow row = sheetData.next();
            String groupName = row.getGroup();
            if (!(!row.gotNewGroup() || rootAttr.booleanValue() && "default".equals(groupName))) {
                try {
                    group = Group.create(this.res.services, this.res.va, this.dsl, childDataSet, groupName, this.res.groupDataSetName);
                }
                catch (TransformationException e) {
                    this.res.falloutReport.report(row.getCurrentLocationInfo(), groupName, "child group error", e.getMessage());
                    group = null;
                    continue;
                }
            }
            if (row.getParameterKey() == null) continue;
            if (rootAttr.booleanValue() && "default".equals(groupName)) {
                DsParameterSup paramSup = new DsParameterSup(paramContainer, row.getParameterKey());
                Cell cell = row.getParameterValueCell();
                EvaluationContext.getContext().put(this.res.excelEvaluator, cell, paramSup);
                continue;
            }
            if (group == null) continue;
            String attributeInGroupName = row.getParameterKey();
            try {
                ChildParameterSup parameterSup = ChildParameterSup.create(group, attributeInGroupName);
                Cell paramValueCell = row.getParameterValueCell();
                EvaluationContext.getContext().put(this.res.excelEvaluator, paramValueCell, parameterSup);
            }
            catch (Exception e) {
                this.res.falloutReport.report(row.getCurrentLocationInfo(), groupName, "parameter in group error", e.getMessage());
            }
        }
    }

    static class ChildDsParamContainer
    implements ParamContainer {
        private final DataSet ds;

        private ChildDsParamContainer(DataSet ds) {
            this.ds = ds;
        }

        static ChildDsParamContainer create(DataSet ds) {
            return new ChildDsParamContainer(ds);
        }

        @Override
        public DataSet getGroupDs() {
            return this.ds;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("ds", (Object)this.ds).toString();
        }
    }

    static class Group
    implements OverlapParamContainer {
        private final DataSet groupDs;
        private final Parameter refToDs;

        private Group(DataSet groupDs, Parameter refToDs) {
            this.groupDs = groupDs;
            this.refToDs = refToDs;
        }

        static Group create(DsServicesFacade services, VisibilityArea va, DataSetList dsl, DataSet ds, String groupDslName, String groupDsName) throws TransformationException {
            DataSetList groupDsl = services.getDslByName(va, groupDslName).orElseThrow(() -> new TransformationException("Group data set list '" + groupDslName + "' is not found"));
            DataSet groupDs = services.getDsByName(groupDsl, groupDsName).orElseThrow(() -> new TransformationException("Default data set is not found in Data set list '" + groupDslName + "'"));
            Attribute refToDsl = services.get_Attr_ByNameOrCreate(dsl, groupDslName, AttributeType.DSL, groupDsl.getId(), null);
            Parameter refToDs = services.get_Param_ByNameOrCreate(ds, refToDsl, groupDs.getId());
            return new Group(groupDs, refToDs);
        }

        @Override
        public Parameter getRefToDs() {
            return this.refToDs;
        }

        @Override
        public DataSet getGroupDs() {
            return this.groupDs;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("groupDs", (Object)this.groupDs).add("refToDs", (Object)this.refToDs).toString();
        }
    }

    static class DsParameterSup
    extends ToCreate {
        private final ChildDsParamContainer paramContainer;
        private final String key;

        private DsParameterSup(ChildDsParamContainer paramContainer, String key) {
            this.paramContainer = paramContainer;
            this.key = key;
        }

        @Override
        @Nonnull
        public ParamContainer getContainer() {
            return this.paramContainer;
        }

        @Override
        @Nonnull
        public String getAttrName() {
            return this.key;
        }
    }

    static class ChildParameterSup
    extends ToOverlap {
        private final Group parent;
        private final Parameter parentParamInGroup;

        private ChildParameterSup(Group parent, Parameter parentParamInGroup) {
            this.parent = parent;
            this.parentParamInGroup = parentParamInGroup;
        }

        static ChildParameterSup create(Group parent, String key) throws TransformationException {
            Attribute attributeToBeOverridden = parent.getGroupDsl().getAttributes().stream().filter(a -> a.getName().equals(key)).findFirst().orElseThrow(() -> new TransformationException("Attribute is not found '" + key + "' under group '" + parent.getGroupDsl().getName() + "'"));
            UUID id = attributeToBeOverridden.getId();
            Parameter parentParamInGroup = parent.getGroupDs().getParameters().stream().filter(p -> p.getAttribute().getId().equals(id)).findFirst().orElseThrow(() -> new TransformationException("Parameter is not found for attribute '" + key + "' under parent group dataset: " + parent.getGroupDs().getName()));
            return new ChildParameterSup(parent, parentParamInGroup);
        }

        @Override
        @Nonnull
        public OverlapParamContainer getContainer() {
            return this.parent;
        }

        @Override
        public Parameter getParameterToOverlap() {
            return this.parentParamInGroup;
        }
    }
}

