/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.apply;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.migration.formula.model.AttachedFiles;
import org.qubership.atp.dataset.migration.formula.model.Formula;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;
import org.qubership.atp.dataset.migration.model.ToOverlap;
import org.qubership.atp.dataset.migration.repo.DsServicesFacade;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.ParameterOverlap;
import org.qubership.atp.dataset.model.impl.file.FileData;

public interface Overlap {
    public static final Overlap TEXT_OR_LIST_VALUE = new Overlap(){

        @Override
        @Nullable
        public ParameterOverlap overlapParameter(DsServicesFacade using, ToOverlap target, Formula value) throws TransformationException {
            Attribute attribute = target.getAttributeToOverlap();
            String lvName = value.getDatasetValue();
            switch (attribute.getType()) {
                case LIST: {
                    ListValue listValue = using.get_ListValue_ByNameOrCreate(attribute, lvName);
                    return using.overlapParameter(target, null, null, listValue.getId());
                }
                case TEXT: {
                    return using.overlapParameter(target, value.getDatasetValue(), null, null);
                }
            }
            throw new TransformationException("Can not overlap parameter of '" + attribute.getType() + "' type.");
        }
    };
    public static final Overlap TEXT_ONLY = (using, target, value) -> {
        Parameter paramToOverlap = target.getParameterToOverlap();
        Preconditions.checkArgument((AttributeType.TEXT == paramToOverlap.getAttribute().getType() ? 1 : 0) != 0, (String)"Can not overlap parameter with type '%s'. Type '%s' expected.", (Object)paramToOverlap.getAttribute().getType(), (Object)AttributeType.TEXT);
        if (target.getParameterToOverlap().getText().equals(value.getDatasetValue())) {
            return null;
        }
        return using.overlapParameter(target, value.getDatasetValue(), null, null);
    };
    public static final Overlap FILE = (using, target, value) -> {
        ParameterOverlap parameter = using.overlapParameter(target, value.getDatasetValue(), null, null);
        FileData fileData = AttachedFiles.createFileParameterFromAttachedFile(value.getFile(), parameter.getId());
        using.fs.save(fileData, (InputStream)new ByteArrayInputStream(value.getFile().getDataBuffer()), false);
        parameter.setFileData(fileData);
        return parameter;
    };
    public static final Overlap SKIP = (using, target, value) -> null;
    public static final Overlap MACROS_AS_TEXT_ONLY = (using, target, value) -> {
        Parameter paramToOverlap = target.getParameterToOverlap();
        Preconditions.checkArgument((AttributeType.TEXT == paramToOverlap.getAttribute().getType() ? 1 : 0) != 0, (String)"Can not overlap parameter with type '%s'. Type '%s' expected.", (Object)paramToOverlap.getAttribute().getType(), (Object)AttributeType.TEXT);
        if (target.getParameterToOverlap().getText().equals(value.getExcelFormulaValue())) {
            return null;
        }
        return using.overlapParameter(target, value.getDatasetValue(), null, null);
    };

    @Nullable
    public ParameterOverlap overlapParameter(DsServicesFacade var1, ToOverlap var2, Formula var3) throws TransformationException;
}

