/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.EvaluationContext;
import org.qubership.atp.dataset.migration.formula.model.FormulaType;
import org.qubership.atp.dataset.migration.formula.model.ParameterAssociation;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;
import org.qubership.atp.dataset.migration.formula.parsers.RegexpFormulaAdapter;

public class InternalReferenceParser
extends RegexpFormulaAdapter {
    private static final String REFERENCE_REGEX = "[a-zA-Z]+\\d+";
    private static final Pattern justReference = Pattern.compile("[a-zA-Z]+\\d+");

    @Override
    public FormulaType getType() {
        return FormulaType.REFERENCE;
    }

    @Override
    public String transform(CellData cellData) throws TransformationException {
        Matcher matcher = this.getMatcher(cellData);
        String cellAddress = matcher.group();
        EvaluationContext context = EvaluationContext.getContext();
        ParameterAssociation referencedParameter = context.get(cellData);
        if (referencedParameter == null) {
            throw new TransformationException("reference '" + cellAddress + "' links to nowhere");
        }
        return this.getAddress(referencedParameter);
    }

    private String getAddress(ParameterAssociation referencedParameter) {
        return String.format("#REF_DSL(%s.%s.%s)", referencedParameter.parameterSup.getContainer().getGroupDsl().getName(), referencedParameter.parameterSup.getContainer().getGroupDs().getName(), referencedParameter.parameterSup.getAttrName());
    }

    @Override
    protected Pattern getPattern() {
        return justReference;
    }

    @Override
    protected String getFormulaDescription() {
        return "[a-zA-Z]+\\d+ (excel link to the another cell, e.g. =C11)";
    }
}

