/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.parsers;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.ExcelFormulaAdapter;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;

public abstract class RegexpFormulaAdapter
implements ExcelFormulaAdapter {
    @Override
    public boolean matches(CellData cellData) {
        return this.getValidMatcher(cellData).isPresent();
    }

    @Nonnull
    protected final Matcher getMatcher(CellData cellData) throws TransformationException {
        Optional<Matcher> matcher = this.getValidMatcher(cellData);
        if (!matcher.isPresent()) {
            throw new TransformationException("Text '" + cellData + "' is not supported expression: " + this.getFormulaDescription());
        }
        return matcher.get();
    }

    protected abstract Pattern getPattern();

    protected abstract String getFormulaDescription();

    private Optional<Matcher> getValidMatcher(CellData cellData) {
        Matcher matcher = this.getPattern().matcher(cellData.getFormula());
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(matcher);
    }
}

