/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.FormulaType;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;
import org.qubership.atp.dataset.migration.formula.parsers.RegexpFormulaAdapter;

public class SimpleTextExcelParser
extends RegexpFormulaAdapter {
    private static final String TEXT_REGEXP = "\"([^\"]*)\"";
    private static final Pattern SIMPLE_VALUE_PATTERN = Pattern.compile("\"([^\"]*)\"");

    @Override
    public FormulaType getType() {
        return FormulaType.CONSTANT_TEXT_VALUE;
    }

    @Override
    public String transform(CellData cellData) throws TransformationException {
        Matcher matcher = this.getMatcher(cellData);
        return matcher.group(1);
    }

    @Override
    protected Pattern getPattern() {
        return SIMPLE_VALUE_PATTERN;
    }

    @Override
    protected String getFormulaDescription() {
        return "\"([^\"]*)\" (simple text in cell \"sometext\")";
    }
}

