/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.repo;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.migration.model.OverlapParamContainer;
import org.qubership.atp.dataset.migration.model.ToOverlap;
import org.qubership.atp.dataset.migration.repo.OrderedAttributeRepository;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.ParameterOverlap;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.GridFsService;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.VisibilityAreaService;

public class DsServicesFacade {
    public final VisibilityAreaService va;
    public final DataSetListService dsl;
    public final ParameterService param;
    public final AttributeService attr;
    public final GridFsService fs;
    private final OrderedAttributeRepository attrRepo;
    private final DataSetService ds;

    public DsServicesFacade(VisibilityAreaService va, DataSetListService dsl, OrderedAttributeRepository attrRepo, DataSetService ds, ParameterService param, AttributeService attr, GridFsService fs) {
        this.va = va;
        this.dsl = dsl;
        this.attrRepo = attrRepo;
        this.ds = ds;
        this.param = param;
        this.attr = attr;
        this.fs = fs;
    }

    public ParameterOverlap overlapParameter(ToOverlap childParameter, String textValue, UUID dsRef, UUID listValueRef) {
        UUID attrId = childParameter.getAttributeToOverlap().getId();
        OverlapParamContainer childGroup = childParameter.getContainer();
        UUID rootDataSetId = childGroup.getDs().getId();
        return this.param.set(rootDataSetId, attrId, Collections.singletonList(childGroup.getRefToDsl().getId()), textValue, dsRef, listValueRef).asOverlap();
    }

    public VisibilityArea get_VA_ByNameOrCreate(String vaName) {
        return this.va.getAll().stream().filter(visibilityArea -> visibilityArea.getName().equals(vaName)).findFirst().orElseGet(() -> this.va.create(vaName));
    }

    public Optional<DataSetList> getDslByName(VisibilityArea visibilityArea, String dslName) {
        return visibilityArea.getDataSetLists().stream().filter(dsl -> dsl.getName().equals(dslName)).findFirst();
    }

    public DataSetList getDslByNameOrCreate(VisibilityArea visibilityArea, String dslName) {
        return this.getDslByName(visibilityArea, dslName).orElseGet(() -> (DataSetList)this.dsl.get(this.dsl.create(visibilityArea.getId(), dslName, null).getId()));
    }

    public Optional<DataSet> getDsByName(DataSetList dataSetList, String dataSetName) {
        return dataSetList.getDataSets().stream().filter(ds -> ds.getName().equals(dataSetName)).findFirst();
    }

    public DataSet get_DS_ByNameOrCreate(String dataSetName, DataSetList dataSetList) {
        return this.getDsByName(dataSetList, dataSetName).orElseGet(() -> this.ds.create(dataSetList.getId(), dataSetName));
    }

    public Attribute get_Attr_ByNameOrCreate(DataSetList dataSetList, String paramName, AttributeType attributeType, UUID dslRefId, @Nullable List<String> listValues) {
        return this.attrRepo.getByParentId(dataSetList.getId()).stream().filter(attribute -> attribute.getName().equals(paramName)).findFirst().orElseGet(() -> this.attrRepo.create(dataSetList.getId(), paramName, attributeType, dslRefId, listValues));
    }

    public ListValue get_ListValue_ByNameOrCreate(Attribute attribute, String name) {
        Attribute freshInstance = (Attribute)this.attr.get(attribute.getId());
        Preconditions.checkNotNull((Object)freshInstance);
        return freshInstance.getListValues().stream().filter(lv -> lv.getName().equals(name)).findAny().orElseGet(() -> this.attr.createListValue(attribute.getId(), name));
    }

    public Parameter get_Param_ByNameOrCreate(DataSet dataSet, Attribute attribute, UUID typeDslId) {
        DataSet freshInstance = (DataSet)this.ds.get(dataSet.getId());
        Preconditions.checkNotNull((Object)freshInstance);
        return freshInstance.getParameters().stream().filter(parameter -> parameter.getAttribute().getId().equals(attribute.getId())).findFirst().orElseGet(() -> this.param.create(dataSet.getId(), attribute.getId(), null, null, typeDslId));
    }
}

