/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.crypt;

import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.qubership.atp.crypt.AtpCryptoFactory;
import org.qubership.atp.crypt.ConverterTools;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.api.Encryptor;
import org.qubership.atp.crypt.api.KeyEntity;

public class KeyPairGenerator {
    private static final List<Integer> AES_KEY_CORRECT_LENGTH = new ArrayList<Integer>(Arrays.asList(16, 24, 32));

    public KeyEntity generateKeys() throws Exception {
        SecretKey secretKey = this.generateAesKey();
        String key = ConverterTools.encode(secretKey.getEncoded());
        return this.generateKeys(key);
    }

    public KeyEntity generateKeys(String key) throws Exception {
        KeyPair kp = this.generateRsaKeyPair();
        String privateKey = ConverterTools.encode(kp.getPrivate().getEncoded());
        String publicKey = ConverterTools.encode(kp.getPublic().getEncoded());
        Encryptor encryptor = AtpCryptoFactory.createDefaultRsaEncryptor(publicKey);
        String encryptedKey = encryptor.encrypt(key);
        return new KeyEntity(key, encryptedKey, publicKey, privateKey);
    }

    private SecretKey generateAesKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        return keyGenerator.generateKey();
    }

    private KeyPair generateRsaKeyPair() throws NoSuchAlgorithmException {
        java.security.KeyPairGenerator rsa = java.security.KeyPairGenerator.getInstance("RSA");
        rsa.initialize(2048);
        return rsa.generateKeyPair();
    }

    public static void main(String[] arg) throws Exception {
        int maxKeySize = Cipher.getMaxAllowedKeyLength("AES");
        System.out.println("Max Key Size for AES = " + maxKeySize);
        KeyPairGenerator generator = new KeyPairGenerator();
        KeyEntity keys = null != arg && arg.length > 0 && null != arg[0] && StringUtils.isNotEmpty((String)arg[0]) ? generator.generateKeys(arg[0]) : generator.generateKeys();
        System.out.println(keys);
        System.out.println();
        System.out.println("Encryption/Decryption test...");
        Encryptor encryptor = AtpCryptoFactory.createDefaultAesEncryptor(keys.getKey());
        String encryptedData = encryptor.encrypt("Key is valid");
        System.out.println("Encrypted data = " + encryptedData);
        Decryptor decryptor = AtpCryptoFactory.createDefaultAesDecryptor(keys.getKey());
        System.out.println("Decrypted data = " + decryptor.decrypt(encryptedData));
    }

    public Object readPublicKey(String publicKey) throws Exception {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        if (publicKey.trim().startsWith("-----BEGIN")) {
            try (StringReader keyReader = new StringReader(publicKey);){
                PublicKey publicKey2;
                try (PemReader pemReader = new PemReader((Reader)keyReader);){
                    PemObject pemObject = pemReader.readPemObject();
                    byte[] content = pemObject.getContent();
                    X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(content);
                    publicKey2 = factory.generatePublic(pubKeySpec);
                }
                return publicKey2;
            }
        }
        byte[] keyBytes = ConverterTools.decode(publicKey);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        return factory.generatePublic(spec);
    }

    public Object readPrivateKey(String privateKeyString) throws Exception {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        if (privateKeyString.trim().startsWith("-----BEGIN")) {
            try (StringReader keyReader = new StringReader(privateKeyString);){
                PrivateKey privateKey;
                try (PemReader pemReader = new PemReader((Reader)keyReader);){
                    PemObject pemObject = pemReader.readPemObject();
                    byte[] content = pemObject.getContent();
                    PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(content);
                    privateKey = factory.generatePrivate(privateKeySpec);
                }
                return privateKey;
            }
        }
        byte[] keyBytes = ConverterTools.decode(privateKeyString);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        return factory.generatePrivate(spec);
    }

    public Object readKey(String keyString) throws Exception {
        byte[] bytes;
        block12: {
            if (keyString.trim().startsWith("-----BEGIN")) {
                try (StringReader keyReader = new StringReader(keyString);
                     PemReader pemReader = new PemReader((Reader)keyReader);){
                    PemObject pemObject = pemReader.readPemObject();
                    bytes = pemObject.getContent();
                    break block12;
                }
            }
            bytes = ConverterTools.decode(keyString);
        }
        if (!AES_KEY_CORRECT_LENGTH.contains(bytes.length)) {
            throw new IllegalArgumentException("Wrong length for AES key");
        }
        return new SecretKeySpec(bytes, "AES");
    }
}

