/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpanBuilder;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.cassandra.CassandraSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.cassandra.SleuthCassandraSpan;
import org.springframework.cloud.sleuth.instrument.cassandra.TraceStatement;
import org.springframework.cloud.sleuth.internal.ContextUtil;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

class TraceCqlSessionInterceptor
implements MethodInterceptor {
    private static final Log log = LogFactory.getLog(TraceCqlSessionInterceptor.class);
    private final CqlSession delegate;
    private final BeanFactory beanFactory;
    private Tracer tracer;
    private CurrentTraceContext currentTraceContext;

    TraceCqlSessionInterceptor(CqlSession delegate, BeanFactory beanFactory) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
    }

    @Nullable
    public Object invoke(@NonNull MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        if (this.isContextUnusable()) {
            return invocation.proceed();
        }
        if (method.getName().equals("execute") && args.length > 0) {
            return this.tracedCall(TraceCqlSessionInterceptor.createStatement(args), "execute", arg_0 -> ((CqlSession)this.delegate).execute(arg_0));
        }
        if (method.getName().equals("executeAsync") && args.length > 0) {
            return this.tracedCall(TraceCqlSessionInterceptor.createStatement(args), "executeAsync", arg_0 -> ((CqlSession)this.delegate).executeAsync(arg_0));
        }
        if (method.getName().equals("prepare") && args.length > 0) {
            return this.tracedCall(TraceCqlSessionInterceptor.createStatement(args), "prepare", statement -> this.delegate.prepare((SimpleStatement)statement));
        }
        if (method.getName().equals("prepareAsync") && args.length > 0) {
            return this.tracedCall(TraceCqlSessionInterceptor.createStatement(args), "prepareAsync", statement -> this.delegate.prepareAsync((SimpleStatement)statement));
        }
        return invocation.proceed();
    }

    private static Statement<?> createStatement(Object[] args) {
        if (args[0] instanceof Statement) {
            return (Statement)args[0];
        }
        if (args[0] instanceof String && args.length == 1) {
            return SimpleStatement.newInstance((String)((String)args[0]));
        }
        if (args[0] instanceof String && args.length == 2) {
            String query = (String)args[0];
            return args[1] instanceof Map ? SimpleStatement.newInstance((String)query, (Map)((Map)args[1])) : SimpleStatement.newInstance((String)query, (Object[])((Object[])args[1]));
        }
        throw new IllegalArgumentException(String.format("Unsupported arguments %s", Arrays.toString(args)));
    }

    boolean isContextUnusable() {
        return ContextUtil.isContextUnusable(this.beanFactory);
    }

    private Object tracedCall(Statement<?> statement, String defaultSpanName, Function<Statement<?>, Object> function) {
        Span span = this.cassandraClientSpan();
        Statement<?> proxied = TraceStatement.isTraceStatement(statement) ? statement : TraceStatement.createProxy(span, statement);
        ((CassandraSpanCustomizer)proxied).customizeSpan(defaultSpanName);
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().maybeScope(span.context());){
            log.debug((Object)"Will execute statement");
            Object object = function.apply(proxied);
            return object;
        }
    }

    private Span cassandraClientSpan() {
        return TraceCqlSessionInterceptor.cassandraClientSpan(this.tracer().spanBuilder(), this.getSessionName(), this.getKeyspace());
    }

    static Span cassandraClientSpan(Span.Builder builder, String sessionName, Optional<CqlIdentifier> keyspace) {
        return AssertingSpanBuilder.of((DocumentedSpan)SleuthCassandraSpan.CASSANDRA_SPAN, (Span.Builder)builder).kind(Span.Kind.CLIENT).remoteServiceName("cassandra-" + sessionName).tag((TagKey)SleuthCassandraSpan.Tags.KEYSPACE_NAME, keyspace.map(CqlIdentifier::asInternal).orElse("unknown")).start();
    }

    String getSessionName() {
        return this.delegate.getContext().getSessionName();
    }

    Optional<CqlIdentifier> getKeyspace() {
        return this.delegate.getKeyspace();
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }
}

