/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.configuration;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(value={"atp.audit.logging.enable"}, havingValue="true")
public class AuditAspect {
    private static final Logger log = LoggerFactory.getLogger(AuditAspect.class);
    public static final TemplateParserContext TEMPLATE_PARSER_CONTEXT = new TemplateParserContext("{{", "}}");
    public static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();

    @Before(value="@annotation(org.qubership.atp.integration.configuration.configuration.AuditAction)")
    public void around(JoinPoint joinPoint) {
        log.debug("Capture user action");
        try {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            AuditAction annotation = signature.getMethod().getAnnotation(AuditAction.class);
            String[] parameterNames = signature.getParameterNames();
            StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
            Object[] args = joinPoint.getArgs();
            for (int i = 0; i < args.length; ++i) {
                evaluationContext.setVariable(parameterNames[i], args[i]);
            }
            String value = (String)EXPRESSION_PARSER.parseExpression(annotation.auditAction(), (ParserContext)TEMPLATE_PARSER_CONTEXT).getValue((EvaluationContext)evaluationContext, String.class);
            MdcUtils.put("userAction", value);
        }
        catch (Exception e) {
            log.error("Can not update audit action trace:", (Throwable)e);
        }
    }
}

