/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.crypt.impl;

import org.qubership.atp.crypt.api.CryptoProvider;
import org.qubership.atp.crypt.api.Encryptor;
import org.qubership.atp.crypt.exception.AtpEncryptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptorImpl
implements Encryptor {
    private static final Logger log = LoggerFactory.getLogger(EncryptorImpl.class);
    private final String transformation;
    private final Object key;
    private final CryptoProvider provider;

    public EncryptorImpl(String transformation, CryptoProvider provider, Object key) {
        this.transformation = transformation;
        this.key = key;
        this.provider = provider;
    }

    @Override
    public String encrypt(String data, Object key) throws AtpEncryptException {
        try {
            return this.provider.encrypt(this.transformation, data, key);
        }
        catch (Exception e) {
            throw new AtpEncryptException("Encrypting failed.", e);
        }
    }

    @Override
    public String encrypt(String data) throws AtpEncryptException {
        return this.encrypt(data, this.key);
    }
}

