/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final Pattern PLACEHOLDER = Pattern.compile("\\$\\{([^}]*)}");

    public static void closeQuietly(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOGGER.warn("Can not close resource: " + closeable, (Throwable)e);
        }
    }

    public static String replacePlaceholders(String in, Function<String, String> placeholderIntoValue) {
        Matcher matcher = PLACEHOLDER.matcher(in);
        return Utils.replacePlaceholders(matcher, 1, placeholderIntoValue);
    }

    public static String replacePlaceholders(Matcher matcher, Function<String, String> placeholderIntoValue) {
        return Utils.replacePlaceholders(matcher, 0, placeholderIntoValue);
    }

    private static String replacePlaceholders(Matcher matcher, int groupToConvert, Function<String, String> placeholderIntoValue) {
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, placeholderIntoValue.apply(matcher.group(groupToConvert)));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static <T> T doInstance(@Nonnull Class<T> targetClazz, @Nonnull String className, @Nullable String debugIdentifier) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException firstEx) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    throw new ClassNotFoundException("Have no context class loader");
                }
                clazz = cl.loadClass(className);
            }
            catch (ClassNotFoundException secondEx) {
                RuntimeException lastEx = new RuntimeException(Utils.appendDebugInfo(new StringBuilder("Can not find"), targetClazz, className, debugIdentifier).toString(), firstEx);
                lastEx.addSuppressed(secondEx);
                throw lastEx;
            }
        }
        try {
            return targetClazz.cast(clazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(Utils.appendDebugInfo(new StringBuilder("Can not instantiate a"), targetClazz, className, debugIdentifier).toString(), e);
        }
    }

    @Nonnull
    private static StringBuilder appendDebugInfo(@Nonnull StringBuilder builder, @Nonnull Class<?> targetClazz, @Nonnull String className, @Nullable String debugIdentifier) {
        builder.append(" class [").append(className).append("] of [").append(targetClazz.getName()).append("]");
        if (debugIdentifier != null) {
            builder.append(" for [").append(debugIdentifier).append("]");
        }
        return builder;
    }
}

