/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation.aws;

import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.TraceIdContext;
import brave.propagation.aws.AWSPropagation;

final class AWSExtractor<R>
implements TraceContext.Extractor<R> {
    static final TraceContextOrSamplingFlags EMPTY = TraceContextOrSamplingFlags.EMPTY.toBuilder().addExtra((Object)AWSPropagation.EXTRA_MARKER).build();
    final AWSPropagation propagation;
    final Propagation.Getter<R, String> getter;

    AWSExtractor(AWSPropagation propagation, Propagation.Getter<R, String> getter) {
        this.propagation = propagation;
        this.getter = getter;
    }

    /*
     * Enabled aggressive block sorting
     */
    public TraceContextOrSamplingFlags extract(R request) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        String traceIdString = this.getter.get(request, (Object)"x-amzn-trace-id");
        if (traceIdString == null) {
            return EMPTY;
        }
        Boolean sampled = null;
        long traceIdHigh = 0L;
        long traceId = 0L;
        Long parent = null;
        StringBuilder currentString = new StringBuilder(7);
        StringBuilder extraFields = null;
        Enum op = null;
        int length = traceIdString.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = traceIdString.charAt(i);
            if (c == ' ') continue;
            if (c == '=') {
                if (++i == length) break;
                if (currentString.indexOf("Root") == 0) {
                    op = Op.ROOT;
                } else if (currentString.indexOf("Parent") == 0) {
                    op = Op.PARENT;
                } else if (currentString.indexOf("Sampled") == 0) {
                    op = Op.SAMPLED;
                } else if (currentString.indexOf("Self") == 0) {
                    op = Op.SKIP;
                } else {
                    op = Op.EXTRA;
                    if (extraFields == null) {
                        extraFields = new StringBuilder();
                    }
                    extraFields.append(';').append((CharSequence)currentString);
                }
                currentString.setLength(0);
            } else if (op == null) {
                currentString.append(c);
                continue;
            }
            switch (1.$SwitchMap$brave$propagation$aws$AWSExtractor$Op[op.ordinal()]) {
                case 1: {
                    extraFields.append(c);
                    while (i < length && (c = traceIdString.charAt(i)) != ';') {
                        extraFields.append(c);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    while (++i < length && traceIdString.charAt(i) != ';') {
                    }
                    break;
                }
                case 3: {
                    if (i + 35 > length || traceIdString.charAt(i++) != '1' || traceIdString.charAt(i++) != '-') break block7;
                    int hyphenIndex = i + 8;
                    int endIndex = hyphenIndex + 1 + 8;
                    while (i < endIndex) {
                        c = traceIdString.charAt(i);
                        if (c != '-' || i != hyphenIndex) {
                            traceIdHigh <<= 4;
                            if (c >= '0' && c <= '9') {
                                traceIdHigh |= (long)(c - 48);
                            } else {
                                if (c < 'a' || c > 'f') break block7;
                                traceIdHigh |= (long)(c - 97 + 10);
                            }
                        }
                        ++i;
                    }
                    int endIndex2 = i + 16;
                    while (i < endIndex2) {
                        c = traceIdString.charAt(i);
                        traceId <<= 4;
                        if (c >= '0' && c <= '9') {
                            traceId |= (long)(c - 48);
                        } else {
                            if (c < 'a' || c > 'f') break block7;
                            traceId |= (long)(c - 97 + 10);
                        }
                        ++i;
                    }
                    break;
                }
                case 4: {
                    long parentId = 0L;
                    int endIndex = i + 16;
                    while (i < endIndex) {
                        c = traceIdString.charAt(i);
                        parentId <<= 4;
                        if (c >= '0' && c <= '9') {
                            parentId |= (long)(c - 48);
                        } else {
                            if (c < 'a' || c > 'f') break block7;
                            parentId |= (long)(c - 97 + 10);
                        }
                        ++i;
                    }
                    parent = parentId;
                    break;
                }
                case 5: {
                    c = traceIdString.charAt(i++);
                    if (c == '1') {
                        sampled = true;
                        break;
                    }
                    if (c != '0') break;
                    sampled = false;
                }
            }
            op = null;
        }
        AWSPropagation.AmznTraceId amznTraceId = AWSPropagation.EXTRA_MARKER;
        if (extraFields != null) {
            amznTraceId = new AWSPropagation.AmznTraceId();
            amznTraceId.customFields = extraFields;
        }
        if (traceIdHigh == 0L) {
            SamplingFlags samplingFlags = SamplingFlags.EMPTY;
            if (sampled != null) {
                samplingFlags = sampled != false ? SamplingFlags.SAMPLED : SamplingFlags.NOT_SAMPLED;
            }
            return TraceContextOrSamplingFlags.newBuilder((SamplingFlags)samplingFlags).addExtra((Object)amznTraceId).build();
        }
        if (parent == null) {
            return TraceContextOrSamplingFlags.newBuilder((TraceIdContext)TraceIdContext.newBuilder().traceIdHigh(traceIdHigh).traceId(traceId).sampled(sampled).build()).addExtra((Object)amznTraceId).build();
        }
        return TraceContextOrSamplingFlags.create((TraceContext)TraceContext.newBuilder().traceIdHigh(traceIdHigh).traceId(traceId).spanId(parent.longValue()).sampled(sampled).addExtra((Object)amznTraceId).build());
    }

    static enum Op {
        SKIP,
        ROOT,
        PARENT,
        SAMPLED,
        EXTRA;

    }
}

