/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.instrument.async.SleuthAsyncSpan;

public class TraceCallable<V>
implements Callable<V> {
    private static final String DEFAULT_SPAN_NAME = "async";
    private final Tracer tracer;
    private final Callable<V> delegate;
    private final Span parent;
    private final String spanName;

    public TraceCallable(Tracer tracer, SpanNamer spanNamer, Callable<V> delegate) {
        this(tracer, spanNamer, delegate, null);
    }

    public TraceCallable(Tracer tracer, SpanNamer spanNamer, Callable<V> delegate, String name) {
        this.tracer = tracer;
        this.delegate = delegate;
        this.parent = tracer.currentSpan();
        this.spanName = name != null ? name : spanNamer.name(delegate, DEFAULT_SPAN_NAME);
    }

    @Override
    public V call() throws Exception {
        AssertingSpan childSpan = SleuthAsyncSpan.ASYNC_CALLABLE_SPAN.wrap(this.tracer.nextSpan(this.parent)).name(this.spanName);
        try {
            V v;
            block11: {
                Tracer.SpanInScope ws = this.tracer.withSpan(childSpan.start());
                try {
                    v = this.delegate.call();
                    if (ws == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Error | Exception ex) {
                        childSpan.error(ex);
                        throw ex;
                    }
                }
                ws.close();
            }
            return v;
        }
        finally {
            childSpan.end();
        }
    }

    public Callable<V> getDelegate() {
        return this.delegate;
    }
}

