/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.TraceHandlerFunction;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class TraceHandlerAdapter
implements HandlerAdapter {
    private final BeanFactory beanFactory;
    private final HandlerAdapter delegate;

    public TraceHandlerAdapter(HandlerAdapter delegate, BeanFactory beanFactory) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
    }

    public boolean supports(Object handler) {
        return this.delegate.supports(handler);
    }

    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        HandlerFunction handlerFunction = (HandlerFunction)handler;
        TraceHandlerFunction traceHandlerFunction = new TraceHandlerFunction(handlerFunction, this.beanFactory);
        return this.delegate.handle(exchange, (Object)traceHandlerFunction);
    }
}

