/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.logger;

import feign.Logger;
import feign.Request;
import feign.Response;
import feign.slf4j.Slf4jLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Pattern;
import org.qubership.atp.common.logging.adapter.feign.FeignHttpRequest;
import org.qubership.atp.common.logging.config.LoggingProperties;
import org.qubership.atp.common.logging.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;

public class AtpSlf4jLogger
extends Slf4jLogger {
    private static final Logger log = LoggerFactory.getLogger(AtpSlf4jLogger.class);
    private final Logger logger;
    private final LoggingProperties loggingProperties;

    public AtpSlf4jLogger(Class<?> loggerClass, LoggingProperties loggingProperties) {
        this.logger = LoggerFactory.getLogger(loggerClass);
        this.loggingProperties = loggingProperties;
    }

    protected void logRequest(String configKey, Logger.Level logLevel, Request feignRequest) {
        FeignHttpRequest request = new FeignHttpRequest(feignRequest);
        Boolean isLoggedHeaders = this.loggingProperties.logFeignHeaders();
        List<Pattern> ignoreHeadersPattern = this.loggingProperties.getIgnoreFeignHeaderPatterns();
        List<String> logs = Util.getLogRequestData(request, isLoggedHeaders, ignoreHeadersPattern);
        this.log(configKey, String.join((CharSequence)"\n", logs), new Object[0]);
    }

    protected Response logAndRebufferResponse(String configKey, Logger.Level level, Response response, long elapsedTime) throws IOException {
        return this.logger.isDebugEnabled() ? this.logResponse(configKey, level, response) : response;
    }

    private Response logResponse(String configKey, Logger.Level level, Response feignResponse) throws IOException {
        int statusCode = feignResponse.status();
        HttpHeaders httpHeaders = Util.getHttpHeaders(feignResponse.headers());
        HttpStatus httpStatus = HttpStatus.valueOf((int)statusCode);
        Boolean isLoggedHeaders = this.loggingProperties.logFeignHeaders();
        List<Pattern> ignoreHeadersPattern = this.loggingProperties.getIgnoreFeignHeaderPatterns();
        if (feignResponse.body() != null && statusCode != HttpStatus.NO_CONTENT.value() && statusCode != HttpStatus.RESET_CONTENT.value()) {
            byte[] bodyData = feign.Util.toByteArray((InputStream)feignResponse.body().asInputStream());
            List<String> logs = Util.getLogResponseData(httpHeaders, httpStatus, feign.Util.decodeOrDefault((byte[])bodyData, (Charset)Charset.defaultCharset(), (String)""), isLoggedHeaders, ignoreHeadersPattern);
            this.log(configKey, String.join((CharSequence)"\n", logs), new Object[0]);
            return feignResponse.toBuilder().body(bodyData).build();
        }
        List<String> logs = Util.getLogResponseData(httpHeaders, httpStatus, "", isLoggedHeaders, ignoreHeadersPattern);
        this.log(configKey, String.join((CharSequence)"\n", logs), new Object[0]);
        return feignResponse;
    }

    protected void log(String configKey, String message, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        }
    }
}

