/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.atp.integration.configuration.helpers.JwtParseHelper;
import org.qubership.atp.integration.configuration.service.AuditLoggingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuditLoggingFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuditLoggingFilter.class);
    private final AuditLoggingService auditLoggingService;
    private final JwtParseHelper jwtParseHelper;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        log.debug("Intercept request for audit logging");
        String authToken = request.getHeader("Authorization");
        String url = request.getRequestURI();
        if (MDC.getCopyOfContextMap() != null) {
            MDC.getCopyOfContextMap().remove("userAction");
        }
        log.debug("Continue request filter chain");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (StringUtils.isEmpty((Object)authToken)) {
            log.debug("Audit logging was skipped for the '{}' request because of empty Authorization token", (Object)url);
        } else {
            boolean isM2Mtoken;
            try {
                isM2Mtoken = this.jwtParseHelper.isM2Mtoken(authToken);
            }
            catch (Exception e) {
                log.error("Error while checking token type", (Throwable)e);
                isM2Mtoken = false;
            }
            if (isM2Mtoken) {
                log.debug("Audit logging was skipped for the '{}' request because of M2M Authorization token", (Object)url);
            } else {
                this.auditLoggingService.loggingRequest(request, response);
            }
        }
    }

    public AuditLoggingFilter(AuditLoggingService auditLoggingService, JwtParseHelper jwtParseHelper) {
        this.auditLoggingService = auditLoggingService;
        this.jwtParseHelper = jwtParseHelper;
    }
}

