/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.helpers;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.security.jwt.JwtHelper;

public class JwtParseHelper {
    private static final Logger log = LoggerFactory.getLogger(JwtParseHelper.class);
    private static final String SESSION_STATE_KEY = "session_state";
    private static final String NAME_KEY = "name";
    private static final String USER_ID_KEY = "sub";
    private static final String CLIENT_ID_KEY = "clientId";

    public boolean isM2Mtoken(String token) {
        return StringUtils.isNotBlank((CharSequence)this.getValueFromTokenByKey(token, CLIENT_ID_KEY));
    }

    public UUID getSessionIdFromToken(String token) {
        return UUID.fromString(Objects.requireNonNull(this.getValueFromTokenByKey(token, SESSION_STATE_KEY)));
    }

    public String getUsernameFromToken(String token) {
        return this.getValueFromTokenByKey(token, NAME_KEY);
    }

    public UUID getUserIdFromToken(String token) {
        return UUID.fromString(Objects.requireNonNull(this.getValueFromTokenByKey(token, USER_ID_KEY)));
    }

    private String getValueFromTokenByKey(String token, String key) {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                String claims;
                String[] splitToken = token.split(" ");
                if (splitToken.length < 2) {
                    return null;
                }
                JsonParser parser = JsonParserFactory.getJsonParser();
                Map tokenDataMap = parser.parseMap(claims = JwtHelper.decode((String)splitToken[1]).getClaims());
                if (tokenDataMap.containsKey(key)) {
                    return tokenDataMap.get(key).toString();
                }
                return null;
            }
            catch (Exception e) {
                log.error("Cannot parse token with error: ", (Throwable)e);
                throw new IllegalStateException("Failed to parse authorization token");
            }
        }
        log.error("Blank authorization token error");
        throw new IllegalStateException("Blank authorization token error");
    }
}

