/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.interceptors;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.MDC;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class MdcClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    List<String> businessIds;

    public MdcClientHttpRequestInterceptor(List<String> businessIds) {
        this.businessIds = businessIds;
    }

    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.businessIds.forEach(idName -> {
            if (MDC.get((String)idName) != null) {
                request.getHeaders().add(MdcUtils.convertIdNameToHeader(idName), MDC.get((String)idName));
            }
        });
        return execution.execute(request, body);
    }
}

