/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.interceptors;

import brave.Span;
import brave.Tracer;
import brave.propagation.TraceContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.atp.integration.configuration.helpers.JwtParseHelper;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MdcContextHttpInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(MdcContextHttpInterceptor.class);
    private static final String ZIPKIN_TRACE_ID_HEADER_NAME = "Zipkin-Trace-Id";
    private final Tracer tracer;
    private final JwtParseHelper jwtParseHelper;
    private final List<String> businessIds;

    public MdcContextHttpInterceptor(Tracer tracer, JwtParseHelper jwtParseHelper, String businessIdsString) {
        this.jwtParseHelper = jwtParseHelper;
        this.tracer = tracer;
        this.businessIds = MdcUtils.convertIdNamesToList(businessIdsString);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        this.processBusinessIds(request);
        Optional.ofNullable(this.tracer).map(Tracer::currentSpan).map(Span::context).map(TraceContext::traceIdString).ifPresent(traceId -> {
            log.debug("Add traceId {} to response headers", traceId);
            response.setHeader(ZIPKIN_TRACE_ID_HEADER_NAME, traceId);
        });
        return true;
    }

    private void processBusinessIds(HttpServletRequest request) {
        if (!CollectionUtils.isEmpty(this.businessIds)) {
            for (String idName : this.businessIds) {
                if (MDC.get((String)idName) != null) continue;
                this.processPathVariables(request, idName);
                this.processRequestParameters(request, idName);
            }
        }
    }

    private void processPathVariables(HttpServletRequest request, String idName) {
        Object value;
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        String name = idName.trim();
        if (pathVariables != null && (value = pathVariables.get(name)) != null) {
            MdcUtils.put(name, (String)value);
        }
    }

    private void processRequestParameters(HttpServletRequest request, String idName) {
        CharSequence[] value;
        Map parameterMap = request.getParameterMap();
        String name = idName.trim();
        if (parameterMap != null && !StringUtils.isEmpty((Object)(value = (String[])parameterMap.get(name)))) {
            MdcUtils.put(name, String.join((CharSequence)",", value));
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (!CollectionUtils.isEmpty(this.businessIds)) {
            this.businessIds.forEach(MDC::remove);
        }
    }
}

