/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.logging.gelf.logback;

import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.logback.GelfLogbackAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.net.UnknownHostException;
import org.qubership.atp.crypt.CryptoTools;
import org.qubership.atp.integration.configuration.logging.logback.AtpPatternLayoutEncoder;

public class FailSafeGelfLogbackAppender
extends GelfLogbackAppender {
    public static final String PATTERN = "%date{YYYY-MM-dd HH:mm:ss.SS} %-7([%level]) \"%thread\" %X{requestId} [%logger#%method] - %message%n";
    public static final String INFO_MESSAGE = "Switching to fail safe console appender";
    private static final String ERROR_CANT_SEND_GELF_MESSAGE = "Could not send GELF message";
    private static final String ERROR_INVALID_GELF_MESSAGE = "GELF Message is invalid: ";
    private static final short SHORT_MESSAGE_MAX_LENGTH = 250;
    private boolean graylogAvailable = true;
    private ConsoleAppender<ILoggingEvent> consoleAppender;

    public synchronized void doAppend(ILoggingEvent eventObject) {
        if (!this.graylogAvailable) {
            this.consoleAppender.doAppend((Object)eventObject);
            return;
        }
        super.doAppend((Object)eventObject);
    }

    public void reportError(String message, Exception exception) {
        if (exception instanceof UnknownHostException) {
            this.graylogAvailable = false;
            this.addWarn(message, exception);
            this.addInfo(INFO_MESSAGE);
            this.initFailSafeConsoleAppender();
        } else {
            super.reportError(message, exception);
        }
    }

    private void initFailSafeConsoleAppender() {
        this.consoleAppender = new ConsoleAppender();
        this.consoleAppender.setContext(this.getContext());
        AtpPatternLayoutEncoder patternLayoutEncoder = new AtpPatternLayoutEncoder();
        patternLayoutEncoder.setContext(this.context);
        patternLayoutEncoder.setPattern(PATTERN);
        patternLayoutEncoder.start();
        this.consoleAppender.setEncoder((Encoder)patternLayoutEncoder);
        this.consoleAppender.start();
    }

    protected void append(ILoggingEvent event) {
        if (event == null) {
            return;
        }
        try {
            GelfMessage message = this.createGelfMessage(event);
            if (!message.isValid()) {
                this.reportError(ERROR_INVALID_GELF_MESSAGE + message.toJson(), null);
                return;
            }
            String fullMsgMasked = CryptoTools.maskEncryptedData((String)message.getFullMessage());
            message.setFullMessage(fullMsgMasked);
            String shortMessage = fullMsgMasked.length() > 250 ? fullMsgMasked.substring(0, 249) : fullMsgMasked;
            message.setShortMessage(shortMessage);
            if (null == this.gelfSender || !this.gelfSender.sendMessage(message)) {
                this.reportError(ERROR_CANT_SEND_GELF_MESSAGE, null);
            }
        }
        catch (Exception exception) {
            this.reportError(ERROR_CANT_SEND_GELF_MESSAGE + exception.getMessage(), exception);
        }
    }

    public boolean isGraylogAvailable() {
        return this.graylogAvailable;
    }

    public ConsoleAppender<ILoggingEvent> getConsoleAppender() {
        return this.consoleAppender;
    }

    public void setGraylogAvailable(boolean graylogAvailable) {
        this.graylogAvailable = graylogAvailable;
    }

    public void setConsoleAppender(ConsoleAppender<ILoggingEvent> consoleAppender) {
        this.consoleAppender = consoleAppender;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FailSafeGelfLogbackAppender)) {
            return false;
        }
        FailSafeGelfLogbackAppender other = (FailSafeGelfLogbackAppender)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isGraylogAvailable() != other.isGraylogAvailable()) {
            return false;
        }
        ConsoleAppender<ILoggingEvent> this$consoleAppender = this.getConsoleAppender();
        ConsoleAppender<ILoggingEvent> other$consoleAppender = other.getConsoleAppender();
        return !(this$consoleAppender == null ? other$consoleAppender != null : !this$consoleAppender.equals(other$consoleAppender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FailSafeGelfLogbackAppender;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGraylogAvailable() ? 79 : 97);
        ConsoleAppender<ILoggingEvent> $consoleAppender = this.getConsoleAppender();
        result = result * 59 + ($consoleAppender == null ? 43 : $consoleAppender.hashCode());
        return result;
    }

    public String toString() {
        return "FailSafeGelfLogbackAppender(graylogAvailable=" + this.isGraylogAvailable() + ", consoleAppender=" + this.getConsoleAppender() + ")";
    }
}

