/*
 * Decompiled with CFR 0.152.
 */
package brave.rpc;

import brave.Span;
import brave.internal.Platform;
import brave.internal.Throwables;
import brave.rpc.RpcRequest;
import brave.rpc.RpcRequestParser;
import brave.rpc.RpcResponse;
import brave.rpc.RpcResponseParser;

abstract class RpcHandler<Req extends RpcRequest, Resp extends RpcResponse> {
    final RpcRequestParser requestParser;
    final RpcResponseParser responseParser;

    RpcHandler(RpcRequestParser requestParser, RpcResponseParser responseParser) {
        this.requestParser = requestParser;
        this.responseParser = responseParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Span handleStart(Req request, Span span) {
        if (span.isNoop()) {
            return span;
        }
        try {
            this.parseRequest(request, span);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            Platform.get().log("error parsing request {0}", request, t);
        }
        finally {
            long timestamp = ((RpcRequest)((Object)request)).startTimestamp();
            if (timestamp == 0L) {
                span.start();
            } else {
                span.start(timestamp);
            }
        }
        return span;
    }

    void parseRequest(Req request, Span span) {
        span.kind(request.spanKind());
        ((RpcRequest)((Object)request)).parseRemoteIpAndPort(span);
        this.requestParser.parse((RpcRequest)((Object)request), span.context(), span.customizer());
    }

    void parseResponse(Resp response, Span span) {
        this.responseParser.parse((RpcResponse)((Object)response), span.context(), span.customizer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleFinish(Resp response, Span span) {
        if (response == null) {
            throw new NullPointerException("response == null");
        }
        if (span.isNoop()) {
            return;
        }
        if (response.error() != null) {
            span.error(response.error());
        }
        try {
            this.parseResponse(response, span);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            Platform.get().log("error parsing response {0}", response, t);
        }
        finally {
            long finishTimestamp = ((RpcResponse)((Object)response)).finishTimestamp();
            if (finishTimestamp == 0L) {
                span.finish();
            } else {
                span.finish(finishTimestamp);
            }
        }
    }
}

