/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.migration.customchange.task;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.qubership.atp.dataset.db.migration.customchange.dao.ParameterDao;
import org.qubership.atp.dataset.db.migration.customchange.db.ConnectionReceiving;
import org.qubership.atp.dataset.db.migration.customchange.executor.DateMacrosEscapeQuoteExecutor;
import org.qubership.atp.dataset.db.migration.customchange.executor.Executor;
import org.qubership.atp.dataset.db.migration.customchange.model.DateMacros;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscapeQuoteDateMacrosTask
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(EscapeQuoteDateMacrosTask.class);
    private Executor dateMacrosEscapeQuoteExecutor;
    private ParameterDao macrosDateDao;
    private Connection connection;

    private void init(Database database) {
        this.dateMacrosEscapeQuoteExecutor = DateMacrosEscapeQuoteExecutor.builder().build();
        this.connection = ConnectionReceiving.getConnection(database);
        this.macrosDateDao = new ParameterDao(this.connection);
    }

    public void execute(Database database) throws CustomChangeException {
        this.init(database);
        try {
            List<DateMacros> dateMacrosParameters = this.macrosDateDao.selectParameterMacrosDateExists();
            dateMacrosParameters = this.escapeQuoteDateMacros(dateMacrosParameters);
            dateMacrosParameters.forEach(dateMacros -> {
                try {
                    this.macrosDateDao.updateParameterMacrosDate((DateMacros)dateMacros);
                }
                catch (SQLException e) {
                    log.error("Error query execution", (Throwable)e);
                }
            });
        }
        catch (Throwable throwables) {
            throw new CustomChangeException("Can not migrate attributes", throwables);
        }
        finally {
            this.macrosDateDao.close();
        }
    }

    private List<DateMacros> escapeQuoteDateMacros(List<DateMacros> dateMacrosParameters) {
        dateMacrosParameters.forEach(dateMacrosParameter -> dateMacrosParameter.setMacros((String)this.dateMacrosEscapeQuoteExecutor.execute(dateMacrosParameter.getMacros())));
        return dateMacrosParameters;
    }

    public String getConfirmationMessage() {
        return "Passed";
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

