/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.migration;

import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.qubership.atp.dataset.db.migration.LiquibaseFactory;
import org.qubership.atp.dataset.db.migration.classloader.ParentLastClassloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MigrationRunner {
    private static final Logger log = LoggerFactory.getLogger(MigrationRunner.class);
    @Autowired
    private LiquibaseFactory lbFactory;
    @Value(value="${jdbc_type:pg}")
    private String jdbcType;
    @Value(value="${lb.libs.path:../atp-dataset-migration/src/main/scripts}")
    private String sourcePath;
    @Value(value="${drop.database.for.tests:false}")
    private boolean isTests;
    @Value(value="${dataset.migration.module.launch.enabled:true}")
    private boolean migrationModuleLaunchEnabled;

    public void runMigration() {
        if (this.migrationModuleLaunchEnabled) {
            log.info("Migration module launch is Enabled. DB update has been launched.");
            try {
                Liquibase lb = this.lbFactory.create("install.xml");
                if (this.isTests) {
                    log.info("drop database because of flag (drop.database.for.tests)");
                    lb.dropAll();
                }
                lb.update(new Contexts(), new LabelExpression());
                lb.getDatabase().getConnection().close();
                Path path = Paths.get("atp-dataset-migration/target/scripts", new String[0]);
                URL[] urls = new URL[]{path.toUri().toURL()};
                URLClassLoader urlClassLoader = new URLClassLoader(urls);
                ParentLastClassloader customClassLoader = new ParentLastClassloader(urlClassLoader, this.sourcePath, this.jdbcType);
                HashMap<String, ParentLastClassloader> scopeValues = new HashMap<String, ParentLastClassloader>();
                scopeValues.put(Scope.Attr.classLoader.name(), customClassLoader);
                Scope.child(scopeValues, () -> {
                    Liquibase liquibase = this.lbFactory.create("update.xml", (ResourceAccessor)new ClassLoaderResourceAccessor());
                    liquibase.update(new Contexts(), new LabelExpression());
                    liquibase.getDatabase().getConnection().close();
                });
                log.info("DB update completed.");
            }
            catch (Throwable e) {
                log.error("Migration module launch scripts was failed, Uncaught exception", e);
            }
        } else {
            log.info("Migration module launch is Disabled.");
        }
    }
}

