/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.jms.JmsTracing;
import brave.jms.TracingSession;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;

final class TracingXASession
extends TracingSession
implements XATopicSession,
XAQueueSession {
    static TracingXASession create(XASession delegate, JmsTracing jmsTracing) {
        if (delegate instanceof TracingXASession) {
            return (TracingXASession)delegate;
        }
        return new TracingXASession(delegate, jmsTracing);
    }

    TracingXASession(XASession delegate, JmsTracing jmsTracing) {
        super((Session)delegate, jmsTracing);
    }

    public Session getSession() throws JMSException {
        return TracingSession.create(((XASession)this.delegate).getSession(), this.jmsTracing);
    }

    public XAResource getXAResource() {
        return ((XASession)this.delegate).getXAResource();
    }

    public QueueSession getQueueSession() throws JMSException {
        if ((this.types & 0x10) != 16) {
            throw new IllegalStateException(this.delegate + " is not an XAQueueSession");
        }
        QueueSession xats = ((XAQueueSession)this.delegate).getQueueSession();
        return TracingSession.create((Session)xats, this.jmsTracing);
    }

    public TopicSession getTopicSession() throws JMSException {
        if ((this.types & 0x20) != 32) {
            throw new IllegalStateException(this.delegate + " is not an XATopicSession");
        }
        TopicSession xats = ((XATopicSession)this.delegate).getTopicSession();
        return TracingSession.create((Session)xats, this.jmsTracing);
    }
}

