/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.configuration;

import javax.servlet.Filter;
import org.qubership.atp.integration.configuration.filters.MdcHttpFilter;
import org.qubership.atp.integration.configuration.helpers.HttpRequestParseHelper;
import org.qubership.atp.integration.configuration.helpers.JwtParseHelper;
import org.qubership.atp.integration.configuration.helpers.StompHelper;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LoggingHelpersConfiguration {
    @Value(value="${atp.logging.business.keys:userId,projectId,executionRequestId,testRunId,bvTestRunId,bvTestCaseId,environmentId,systemId,subscriberId,tsgSessionId,svpSessionId,dataSetId,dataSetListId,attributeId,itfLiteRequestId,reportType,itfSessionId,itfContextId,callChainId}")
    private String businessIds;

    @Bean
    @Qualifier(value="businessIdsString")
    public String businessIdsString() {
        return this.businessIds;
    }

    @Bean
    public HttpRequestParseHelper httpRequestParseHelper() {
        return new HttpRequestParseHelper();
    }

    @Bean
    public JwtParseHelper jwtParseHelper() {
        return new JwtParseHelper();
    }

    @Bean
    public StompHelper stompHelper() {
        return new StompHelper();
    }

    @Bean
    public Filter mdcHttpFilter(JwtParseHelper jwtParseHelper) {
        return new MdcHttpFilter(jwtParseHelper, MdcUtils.convertIdNamesToList(this.businessIds));
    }
}

