/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.logging.log4j;

import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.qubership.atp.crypt.CryptoTools;

public class AtpLog4jPatternLayout
extends PatternLayout {
    public String format(LoggingEvent event) {
        if (event.getMessage() instanceof String) {
            LoggingEvent maskedEvent = AtpLog4jPatternLayout.getMaskedLoggingEvent(event);
            return super.format(maskedEvent);
        }
        return super.format(event);
    }

    public static LoggingEvent getMaskedLoggingEvent(LoggingEvent event) {
        String message = event.getRenderedMessage();
        String maskedMessage = CryptoTools.maskEncryptedData((String)message);
        Throwable throwable = event.getThrowableInformation() != null ? event.getThrowableInformation().getThrowable() : null;
        return new LoggingEvent(event.fqnOfCategoryClass, (Category)Logger.getLogger((String)event.getLoggerName()), event.timeStamp, (Priority)event.getLevel(), (Object)maskedMessage, throwable);
    }
}

