/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.migration.customchange.executor;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import org.qubership.atp.dataset.db.migration.customchange.constant.JoinerSplitterConstants;
import org.qubership.atp.dataset.db.migration.customchange.constant.RegExpConstants;
import org.qubership.atp.dataset.db.migration.customchange.executor.Executor;
import org.qubership.atp.dataset.db.migration.customchange.model.DateMacros;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateMacrosEscapeQuoteExecutor
implements Executor<String, String> {
    private static final Logger log = LoggerFactory.getLogger(DateMacrosEscapeQuoteExecutor.class);

    @Override
    public String execute(String inputParameter) {
        return this.escapeQuoteDateMacros(inputParameter);
    }

    public String escapeQuoteDateMacros(String updatedValue) {
        log.debug("escapeQuoteDateMacros (updatedValue: {})", (Object)updatedValue);
        List<DateMacros> dateMacros = this.findDateMacros(updatedValue);
        this.escapeTorZSymbolDateMacros(dateMacros);
        return this.replaceMacrosDateInInputString(updatedValue, dateMacros);
    }

    private String replaceMacrosDateInInputString(String updatedValue, List<DateMacros> dateMacros) {
        AtomicReference<String> updatedMacrosValue = new AtomicReference<String>(updatedValue);
        AtomicInteger indexAdded = new AtomicInteger(0);
        dateMacros.forEach(macrosDate -> {
            log.debug("replaceMacrosDateInInputString (macrosDate: {})", macrosDate);
            int startIndex = macrosDate.getStartIndex() + indexAdded.get();
            int lastIndex = macrosDate.getLastIndex() + indexAdded.get();
            log.debug("replaceMacrosDateInInputString (startIndex: {}, lastIndex: {})", (Object)startIndex, (Object)lastIndex);
            updatedMacrosValue.set(JoinerSplitterConstants.EMPTY_STRING_JOINER.join((Object)this.getStringBeforeMacros(startIndex, (String)updatedMacrosValue.get()), (Object)macrosDate.getMacros(), new Object[]{this.getStringAfterMacros(lastIndex, (String)updatedMacrosValue.get())}));
            indexAdded.set(this.calculateIndexForReplace(indexAdded.get(), macrosDate.getLastIndex() - macrosDate.getStartIndex(), macrosDate.getMacros().length()));
        });
        log.info("Update macros syntax (escape quote for date macros) from: {}, to: {}", (Object)updatedValue, (Object)updatedMacrosValue.get());
        return updatedMacrosValue.get();
    }

    private String getStringBeforeMacros(int startIndex, String updateMacrosValue) {
        log.debug("getStringBeforeMacros (startIndex: {}, updateMacrosValue: {})", (Object)startIndex, (Object)updateMacrosValue);
        return updateMacrosValue.substring(0, startIndex);
    }

    private String getStringAfterMacros(int lastIndex, String updateMacrosValue) {
        log.debug("getStringAfterMacros (lastIndex: {}, updateMacrosValue: {})", (Object)lastIndex, (Object)updateMacrosValue);
        return updateMacrosValue.substring(lastIndex);
    }

    private void escapeTorZSymbolDateMacros(List<DateMacros> dateMacros) {
        dateMacros.stream().filter(macrosDate -> this.isDateContainsTorZSymbols(macrosDate.getMacros())).forEachOrdered(macrosDate -> macrosDate.setMacros(this.escapeTorZSymbols(macrosDate.getMacros())));
    }

    private List<DateMacros> findDateMacros(String updatedValue) {
        LinkedList<DateMacros> dateMacros = new LinkedList<DateMacros>();
        Matcher matcher = RegExpConstants.DATE_MACROS_PATTERN.matcher(updatedValue);
        while (matcher.find()) {
            DateMacros dateMacrosValue = DateMacros.builder().startIndex(matcher.start()).lastIndex(matcher.end()).macros(this.getDateMacros(updatedValue, matcher.start(), matcher.end())).build();
            log.info("Date macros was find: {}", (Object)dateMacrosValue);
            dateMacros.add(dateMacrosValue);
        }
        return dateMacros;
    }

    private int calculateIndexForReplace(int indexAdded, int macrosDateLength, int macrosDateTorZEscapedLength) {
        log.debug("calculateIndexForReplace (indexAdded: {}, macrosDateLength: {}, macrosDateTorZEscapedLength: {})", new Object[]{indexAdded, macrosDateLength, macrosDateTorZEscapedLength});
        return indexAdded + macrosDateTorZEscapedLength - macrosDateLength;
    }

    private boolean isDateContainsTorZSymbols(String macrosDateWithParameters) {
        log.debug("isDateContainsTorZSymbols (macrosDateWithParameters: {})", (Object)macrosDateWithParameters);
        Matcher dateTorZMatcher = RegExpConstants.TZ_QUOTE_PATTERN.matcher(macrosDateWithParameters);
        return dateTorZMatcher.find();
    }

    private String getDateMacros(String updatedValue, int startIndex, int lastIndex) {
        log.debug("getDateMacros (updatedValue: {}, startIndex: {}, lastIndex: {})", new Object[]{updatedValue, startIndex, lastIndex});
        return updatedValue.substring(startIndex, lastIndex);
    }

    private String escapeTorZSymbols(String macrosDateWithParameters) {
        log.debug("escapeTorZSymbols (macrosDateWithParameters: {})", (Object)macrosDateWithParameters);
        return macrosDateWithParameters.replaceAll("'T\\\\'|\\\\'T'|\\\\'T\\\\'", "'T'").replaceAll("\\\\'Z\\\\'|'Z\\\\'|\\\\'Z'", "'Z'").replaceAll("'T'", "\\\\'T\\\\'").replaceAll("'Z'", "\\\\'Z\\\\'");
    }

    DateMacrosEscapeQuoteExecutor() {
    }

    public static DateMacrosEscapeQuoteExecutorBuilder builder() {
        return new DateMacrosEscapeQuoteExecutorBuilder();
    }

    public static class DateMacrosEscapeQuoteExecutorBuilder {
        DateMacrosEscapeQuoteExecutorBuilder() {
        }

        public DateMacrosEscapeQuoteExecutor build() {
            return new DateMacrosEscapeQuoteExecutor();
        }

        public String toString() {
            return "DateMacrosEscapeQuoteExecutor.DateMacrosEscapeQuoteExecutorBuilder()";
        }
    }
}

