/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.configuration;

import brave.Tracer;
import org.qubership.atp.integration.configuration.helpers.HttpRequestParseHelper;
import org.qubership.atp.integration.configuration.helpers.JwtParseHelper;
import org.qubership.atp.integration.configuration.interceptors.MdcContextHttpInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class HttpInterceptorConfiguration
implements WebMvcConfigurer {
    private final Tracer tracer;
    private final HttpRequestParseHelper httpRequestParseHelper;
    private final JwtParseHelper jwtParseHelper;
    private final String businessIds;

    public HttpInterceptorConfiguration(@Autowired(required=false) Tracer tracer, HttpRequestParseHelper httpRequestParseHelper, JwtParseHelper jwtParseHelper, @Qualifier(value="businessIdsString") String businessIds) {
        this.httpRequestParseHelper = httpRequestParseHelper;
        this.jwtParseHelper = jwtParseHelper;
        this.tracer = tracer;
        this.businessIds = businessIds;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new MdcContextHttpInterceptor(this.tracer, this.jwtParseHelper, this.businessIds));
    }
}

