/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import org.sonatype.guice.bean.reflect.AbstractDeferredClass;
import org.sonatype.guice.bean.reflect.ClassSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NamedClass<T>
extends AbstractDeferredClass<T> {
    private final ClassSpace space;
    private final String name;

    public NamedClass(ClassSpace space, String name) {
        this.space = space;
        this.name = name;
    }

    @Override
    public Class<T> load() {
        return this.space.loadClass(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return (527 + this.name.hashCode()) * 31 + this.space.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof NamedClass) {
            NamedClass clazz = (NamedClass)rhs;
            return this.name.equals(clazz.name) && this.space.equals(clazz.space);
        }
        return false;
    }

    public String toString() {
        return "Deferred " + this.name + " from " + this.space;
    }
}

