/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.EurekaClient;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaInstanceConfigBean.class, EurekaClient.class}, name={"org.springframework.cloud.config.server.config.ConfigServerProperties"})
public class EurekaClientConfigServerAutoConfiguration {
    @Autowired(required=false)
    private EurekaInstanceConfig instance;
    @Autowired
    private Environment env;

    @PostConstruct
    public void init() {
        if (this.instance == null) {
            return;
        }
        String prefix = this.env.getProperty("spring.cloud.config.server.prefix");
        if (StringUtils.hasText((String)prefix) && !StringUtils.hasText((String)((String)this.instance.getMetadataMap().get("configPath")))) {
            this.instance.getMetadataMap().put("configPath", prefix);
        }
    }
}

