/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.interceptors;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.CollectionUtils;

public class FeignClientMdcContextInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FeignClientMdcContextInterceptor.class);
    private final List<String> businessIds;

    public FeignClientMdcContextInterceptor(String businessIdsString) {
        this.businessIds = MdcUtils.convertIdNamesToList(businessIdsString);
    }

    public void apply(RequestTemplate template) {
        if (!CollectionUtils.isEmpty(this.businessIds)) {
            this.businessIds.stream().filter(idName -> StringUtils.isNotBlank((CharSequence)MDC.get((String)idName))).forEach(idName -> template.header(MdcUtils.convertIdNameToHeader(idName), new String[]{MDC.get((String)idName)}));
        }
    }
}

