/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.migration.customchange.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.db.migration.customchange.constant.QueryConstants;
import org.qubership.atp.dataset.db.migration.customchange.model.DateMacros;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterDao {
    private static final Logger log = LoggerFactory.getLogger(ParameterDao.class);
    private PreparedStatement preparedStatement;
    private Connection connection;
    private ResultSet resultSet;

    public ParameterDao(Connection connection) {
        this.connection = connection;
    }

    public List<DateMacros> selectParameterMacrosDateExists() throws SQLException {
        LinkedList<DateMacros> idStringPair = new LinkedList<DateMacros>();
        this.preparedStatement = this.connection.prepareStatement(QueryConstants.SELECT_PARAMETER_MACROS_DATE);
        this.resultSet = this.preparedStatement.executeQuery();
        while (this.resultSet.next()) {
            UUID id = (UUID)this.resultSet.getObject("id");
            String stringValue = (String)this.resultSet.getObject("string");
            idStringPair.add(DateMacros.builder().id(id).macros(stringValue).build());
        }
        return idStringPair;
    }

    public void updateParameterMacrosDate(DateMacros newValue) throws SQLException {
        this.preparedStatement = this.connection.prepareStatement("UPDATE parameter SET string = ? WHERE id = ?");
        this.preparedStatement.setString(1, newValue.getMacros());
        this.preparedStatement.setObject(2, newValue.getId());
        this.preparedStatement.executeUpdate();
    }

    public void close() {
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
            }
            catch (Exception exception) {
                log.error("Can not close resources", (Throwable)exception);
            }
        }
    }

    public ParameterDao() {
    }
}

