/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpRequest;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpanCustomizer;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;
import org.springframework.cloud.sleuth.http.HttpRequest;
import org.springframework.cloud.sleuth.http.HttpRequestParser;

public class BraveHttpRequestParser
implements HttpRequestParser {
    final brave.http.HttpRequestParser delegate;

    public BraveHttpRequestParser(brave.http.HttpRequestParser delegate) {
        this.delegate = delegate;
    }

    public void parse(HttpRequest request, TraceContext context, SpanCustomizer span) {
        this.delegate.parse(BraveHttpRequest.toBrave(request), BraveTraceContext.toBrave(context), BraveSpanCustomizer.toBrave(span));
    }

    public static brave.http.HttpRequestParser toBrave(HttpRequestParser parser) {
        if (parser instanceof BraveHttpRequestParser) {
            return ((BraveHttpRequestParser)parser).delegate;
        }
        return (request, context, span) -> parser.parse(BraveHttpRequest.fromBrave(request), BraveTraceContext.fromBrave(context), BraveSpanCustomizer.fromBrave(span));
    }
}

