/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.crypt;

import org.qubership.atp.crypt.api.CryptoProvider;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.api.Encryptor;
import org.qubership.atp.crypt.exception.AtpCryptInvalidKeyException;
import org.qubership.atp.crypt.impl.DecryptorImpl;
import org.qubership.atp.crypt.impl.EncryptorImpl;
import org.qubership.atp.crypt.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtpCryptoFactory {
    private static final Logger log = LoggerFactory.getLogger(AtpCryptoFactory.class);
    private static final CryptoProvider DEFAULT_PROVIDER = AtpCryptoFactory.createBouncyCastleProvider();

    public static Encryptor createEncryptor(String transformation, Object key, CryptoProvider provider) {
        return new EncryptorImpl(transformation, provider, key);
    }

    public static Encryptor createEncryptor(String transformation, Object key) {
        return new EncryptorImpl(transformation, AtpCryptoFactory.getDefaultProvider(), key);
    }

    public static Decryptor createDecryptor(String transformation, Object key, CryptoProvider provider) {
        return new DecryptorImpl(transformation, provider, key);
    }

    public static Decryptor createDecryptor(String transformation, Object key) {
        return new DecryptorImpl(transformation, AtpCryptoFactory.getDefaultProvider(), key);
    }

    public static Encryptor createDefaultAesEncryptor(String key) throws AtpCryptInvalidKeyException {
        CryptoProvider defaultProvider = AtpCryptoFactory.getDefaultProvider();
        try {
            return new EncryptorImpl("AES/CBC/PKCS5Padding", AtpCryptoFactory.getDefaultProvider(), defaultProvider.readKey(key));
        }
        catch (Exception e) {
            log.error("Exception on reading private key", (Throwable)e);
            throw new AtpCryptInvalidKeyException("Decrypting failed. Cannot read key.", e);
        }
    }

    public static Decryptor createDefaultAesDecryptor(String key) throws AtpCryptInvalidKeyException {
        CryptoProvider defaultProvider = AtpCryptoFactory.getDefaultProvider();
        try {
            return new DecryptorImpl("AES/CBC/PKCS5Padding", defaultProvider, defaultProvider.readKey(key));
        }
        catch (Exception e) {
            log.error("Exception on reading key", (Throwable)e);
            throw new AtpCryptInvalidKeyException("Decrypting failed. Cannot read key.", e);
        }
    }

    public static Encryptor createDefaultRsaEncryptor(String publicKey) throws AtpCryptInvalidKeyException {
        CryptoProvider defaultProvider = AtpCryptoFactory.getDefaultProvider();
        try {
            return new EncryptorImpl("RSA", AtpCryptoFactory.getDefaultProvider(), defaultProvider.readPublicKey(publicKey));
        }
        catch (Exception e) {
            log.error("Exception on reading public key", (Throwable)e);
            throw new AtpCryptInvalidKeyException("Decrypting failed. Cannot read public key.", e);
        }
    }

    public static Decryptor createDefaultRsaDecryptor(String privateKey) throws AtpCryptInvalidKeyException {
        CryptoProvider defaultProvider = AtpCryptoFactory.getDefaultProvider();
        try {
            return new DecryptorImpl("RSA", AtpCryptoFactory.getDefaultProvider(), defaultProvider.readPrivateKey(privateKey));
        }
        catch (Exception e) {
            log.error("Exception on reading private key", (Throwable)e);
            throw new AtpCryptInvalidKeyException("Decrypting failed. Cannot read private key.", e);
        }
    }

    public static CryptoProvider getDefaultProvider() {
        return DEFAULT_PROVIDER;
    }

    public static CryptoProvider createBouncyCastleProvider() {
        return new BouncyCastleProvider();
    }
}

