/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.crypt.config;

import org.qubership.atp.crypt.AtpCryptoFactory;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.api.Encryptor;
import org.qubership.atp.crypt.config.AtpCryptoConfiguration;
import org.qubership.atp.crypt.exception.AtpCryptoException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AtpEncryptorConfiguration
extends AtpCryptoConfiguration {
    @Value(value="${atp.crypto.key:}")
    private String key;
    @Value(value="${atp.crypto.privateKey:}")
    private String privateKey;

    @Bean(value={"atpEncryptor"})
    public Encryptor atpEncryptor() throws AtpCryptoException {
        this.validateKey(this.key, "atp.crypto.key");
        this.validateKey(this.privateKey, "atp.crypto.privateKey");
        Decryptor rsaDecryptor = AtpCryptoFactory.createDefaultRsaDecryptor(this.privateKey);
        return AtpCryptoFactory.createDefaultAesEncryptor(rsaDecryptor.decrypt(this.key));
    }
}

