/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;

public class ChangeLogHistoryServiceFactory {
    private static ChangeLogHistoryServiceFactory instance;
    private final List<ChangeLogHistoryService> registry = new ArrayList<ChangeLogHistoryService>();
    private final Map<Database, ChangeLogHistoryService> services = new ConcurrentHashMap<Database, ChangeLogHistoryService>();

    public static synchronized ChangeLogHistoryServiceFactory getInstance() {
        if (instance == null) {
            instance = new ChangeLogHistoryServiceFactory();
        }
        return instance;
    }

    public static synchronized void setInstance(ChangeLogHistoryServiceFactory changeLogHistoryServiceFactory) {
        instance = changeLogHistoryServiceFactory;
    }

    public static synchronized void reset() {
        instance = null;
    }

    private ChangeLogHistoryServiceFactory() {
        try {
            for (ChangeLogHistoryService service : Scope.getCurrentScope().getServiceLocator().findInstances(ChangeLogHistoryService.class)) {
                this.register(service);
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public void register(ChangeLogHistoryService changeLogHistoryService) {
        this.registry.add(0, changeLogHistoryService);
    }

    public ChangeLogHistoryService getChangeLogService(Database database) {
        if (this.services.containsKey(database)) {
            return this.services.get(database);
        }
        TreeSet<ChangeLogHistoryService> foundServices = new TreeSet<ChangeLogHistoryService>(new Comparator<ChangeLogHistoryService>(){

            @Override
            public int compare(ChangeLogHistoryService o1, ChangeLogHistoryService o2) {
                return -1 * Integer.compare(o1.getPriority(), o2.getPriority());
            }
        });
        for (ChangeLogHistoryService service : this.registry) {
            if (!service.supports(database)) continue;
            foundServices.add(service);
        }
        if (foundServices.isEmpty()) {
            throw new UnexpectedLiquibaseException("Cannot find ChangeLogHistoryService for " + database.getShortName());
        }
        try {
            ChangeLogHistoryService service;
            ChangeLogHistoryService exampleService = (ChangeLogHistoryService)foundServices.iterator().next();
            Class<?> aClass = exampleService.getClass();
            try {
                aClass.getConstructor(new Class[0]);
                service = (ChangeLogHistoryService)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                service.setDatabase(database);
            }
            catch (NoSuchMethodException e) {
                service = exampleService;
            }
            this.services.put(database, service);
            return service;
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAll() {
        Class<ChangeLogHistoryServiceFactory> clazz = ChangeLogHistoryServiceFactory.class;
        synchronized (ChangeLogHistoryServiceFactory.class) {
            for (ChangeLogHistoryService changeLogHistoryService : this.registry) {
                changeLogHistoryService.reset();
            }
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

