/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.messaging;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.SleuthIntegrationMessagingProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.SleuthMessagingProperties;
import org.springframework.cloud.sleuth.instrument.messaging.MessageHeaderPropagatorGetter;
import org.springframework.cloud.sleuth.instrument.messaging.MessageHeaderPropagatorSetter;
import org.springframework.cloud.sleuth.instrument.messaging.TraceMessagingAspect;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.support.MessageHeaderAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={MessageHeaderAccessor.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnProperty(value={"spring.sleuth.messaging.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SleuthIntegrationMessagingProperties.class, SleuthMessagingProperties.class})
class TraceSpringMessagingAutoConfiguration {
    TraceSpringMessagingAutoConfiguration() {
    }

    @Bean
    @ConditionalOnProperty(value={"spring.sleuth.messaging.aspect.enabled"}, matchIfMissing=true)
    TraceMessagingAspect traceMessagingAspect(Tracer tracer, SpanNamer spanNamer) {
        return new TraceMessagingAspect(tracer, spanNamer);
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageHeaderAccessor.class}, parameterizedContainer={Propagator.Setter.class})
    Propagator.Setter<MessageHeaderAccessor> traceMessagePropagationSetter() {
        return new MessageHeaderPropagatorSetter();
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageHeaderAccessor.class}, parameterizedContainer={Propagator.Getter.class})
    Propagator.Getter<MessageHeaderAccessor> traceMessagePropagationGetter() {
        return new MessageHeaderPropagatorGetter();
    }
}

