/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.prometheus;

import io.prometheus.client.exemplars.tracer.common.SpanContextSupplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.prometheus.LazySleuthSpanContextSupplier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SpanContextSupplier.class})
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(name={"org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusMetricsExportAutoConfiguration"})
public class PrometheusExemplarsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.sleuth.prometheus.exemplars.enabled"}, matchIfMissing=true)
    SpanContextSupplier sleuthSpanContextSupplier(ObjectProvider<Tracer> tracerProvider) {
        return new LazySleuthSpanContextSupplier(tracerProvider);
    }
}

