/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.migration;

import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.springframework.beans.factory.annotation.Autowired;

public class LiquibaseFactory {
    private final DataSource dataSource;

    @Autowired
    public LiquibaseFactory(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Liquibase create(String pathToChangeLog) throws SQLException, LiquibaseException {
        return this.create(pathToChangeLog, (ResourceAccessor)new ClassLoaderResourceAccessor());
    }

    public Liquibase create(String pathToChangeLog, ResourceAccessor resourceAccessor) throws SQLException, LiquibaseException {
        JdbcConnection connection = new JdbcConnection(this.dataSource.getConnection());
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
        return new Liquibase(pathToChangeLog, resourceAccessor, database);
    }
}

